/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.vfs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.impl.StandardFileSystemManager;
import org.apache.synapse.transport.base.AbstractTransportSender;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.transport.base.BaseTransportException;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.vfs.VFSOutTransportInfo;
import org.apache.synapse.transport.vfs.VFSUtils;

public class VFSTransportSender
extends AbstractTransportSender {
    public static final String TRANSPORT_NAME = "vfs";
    private FileSystemManager fsManager = null;

    public VFSTransportSender() {
        this.log = LogFactory.getLog(VFSTransportSender.class);
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        this.setTransportName(TRANSPORT_NAME);
        super.init(cfgCtx, transportOut);
        try {
            StandardFileSystemManager fsm = new StandardFileSystemManager();
            fsm.setConfiguration(((Object)((Object)this)).getClass().getClassLoader().getResource("providers.xml"));
            fsm.init();
            this.fsManager = fsm;
        }
        catch (FileSystemException e) {
            this.handleException("Error initializing the file transport : " + e.getMessage(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        VFSOutTransportInfo vfsOutInfo = null;
        if (targetAddress != null) {
            vfsOutInfo = new VFSOutTransportInfo(targetAddress);
        } else if (outTransportInfo != null && outTransportInfo instanceof VFSOutTransportInfo) {
            vfsOutInfo = (VFSOutTransportInfo)outTransportInfo;
        }
        if (vfsOutInfo != null) {
            FileObject replyFile = null;
            try {
                boolean wasError = true;
                int retryCount = 0;
                int maxRetryCount = VFSUtils.getMaxRetryCount(msgCtx, vfsOutInfo);
                long reconnectionTimeout = VFSUtils.getReconnectTimout(msgCtx, vfsOutInfo);
                while (wasError) {
                    block27: {
                        try {
                            ++retryCount;
                            replyFile = this.fsManager.resolveFile(vfsOutInfo.getOutFileURI());
                            if (replyFile == null) {
                                this.log.error((Object)"replyFile is null");
                                throw new FileSystemException("replyFile is null");
                            }
                            wasError = false;
                        }
                        catch (FileSystemException e) {
                            this.log.error((Object)"cannot resolve replyFile", (Throwable)e);
                            if (maxRetryCount > retryCount) break block27;
                            this.handleException("cannot resolve replyFile repeatedly: " + e.getMessage(), (Exception)((Object)e));
                        }
                    }
                    if (!wasError) continue;
                    try {
                        Thread.sleep(reconnectionTimeout);
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
                if (replyFile.exists()) {
                    if (replyFile.getType() == FileType.FOLDER) {
                        FileObject responseFile = this.fsManager.resolveFile(replyFile, VFSUtils.getFileName(msgCtx, vfsOutInfo));
                        if (!responseFile.exists()) {
                            responseFile.createFile();
                        }
                        this.populateResponseFile(responseFile, msgCtx);
                    }
                    if (replyFile.getType() == FileType.FILE) {
                        this.populateResponseFile(replyFile, msgCtx);
                    }
                    this.handleException("Unsupported reply file type : " + replyFile.getType() + " for file : " + vfsOutInfo.getOutFileURI());
                }
                replyFile.createFile();
                this.populateResponseFile(replyFile, msgCtx);
            }
            catch (FileSystemException e) {
                this.handleException("Error resolving reply file : " + vfsOutInfo.getOutFileURI(), (Exception)((Object)e));
            }
            finally {
                if (replyFile != null) {
                    try {
                        replyFile.close();
                    }
                    catch (FileSystemException ignore) {}
                }
            }
        } else {
            this.handleException("Unable to determine out transport information to send message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateResponseFile(FileObject responseFile, MessageContext msgContext) throws AxisFault {
        block23: {
            OMElement firstChild = msgContext.getEnvelope().getBody().getFirstElement();
            if (firstChild != null) {
                if (BaseConstants.DEFAULT_BINARY_WRAPPER.equals(firstChild.getQName())) {
                    try {
                        OutputStream os = responseFile.getContent().getOutputStream();
                        try {
                            Object dh;
                            OMNode omNode = firstChild.getFirstOMChild();
                            if (omNode == null || !(omNode instanceof OMText) || (dh = ((OMText)omNode).getDataHandler()) == null || !(dh instanceof DataHandler)) break block23;
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            try {
                                ((DataHandler)dh).writeTo((OutputStream)baos);
                            }
                            catch (IOException e) {
                                this.handleException("Error serializing binary content of element : " + BaseConstants.DEFAULT_BINARY_WRAPPER, e);
                            }
                            os.write(baos.toByteArray());
                        }
                        finally {
                            os.close();
                        }
                    }
                    catch (FileSystemException e) {
                        this.handleException("Error getting an output stream to file : " + responseFile.getName().getBaseName(), (Exception)((Object)e));
                    }
                    catch (IOException e) {
                        this.handleException("Error getting binary content of message", e);
                    }
                } else if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(firstChild.getQName())) {
                    try {
                        OutputStream os = responseFile.getContent().getOutputStream();
                        try {
                            if (firstChild instanceof OMSourcedElementImpl) {
                                firstChild.serializeAndConsume(os);
                            } else {
                                os.write(firstChild.getText().getBytes());
                            }
                        }
                        finally {
                            os.close();
                        }
                    }
                    catch (FileSystemException e) {
                        this.handleException("Error getting an output stream to file : " + responseFile.getName().getBaseName(), (Exception)((Object)e));
                    }
                    catch (IOException e) {
                        this.handleException("Error getting text content of message as bytes", e);
                    }
                    catch (XMLStreamException e) {
                        this.handleException("Error serializing OMSourcedElement content", e);
                    }
                } else {
                    this.populateSOAPFile(responseFile, msgContext);
                }
            } else {
                this.populateSOAPFile(responseFile, msgContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSOAPFile(FileObject responseFile, MessageContext msgContext) throws AxisFault {
        OMOutputFormat format = BaseUtils.getOMOutputFormat(msgContext);
        MessageFormatter messageFormatter = null;
        try {
            messageFormatter = TransportUtils.getMessageFormatter((MessageContext)msgContext);
        }
        catch (AxisFault axisFault) {
            throw new BaseTransportException("Unable to get the message formatter to use");
        }
        try {
            OutputStream os = responseFile.getContent().getOutputStream();
            try {
                messageFormatter.writeTo(msgContext, format, os, true);
            }
            finally {
                os.close();
            }
        }
        catch (FileSystemException e) {
            this.handleException("IO Error while creating response file : " + responseFile.getName(), (Exception)((Object)e));
        }
        catch (IOException e) {
            this.handleException("IO Error while creating response file : " + responseFile.getName(), e);
        }
    }
}

