/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp.util;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.nhttp.util.WorkerPool;

public class BackportWorkerPool
implements WorkerPool {
    private static final Log log = LogFactory.getLog(BackportWorkerPool.class);
    Executor nativeExecutor = null;
    edu.emory.mathcs.backport.java.util.concurrent.Executor executor = null;

    public BackportWorkerPool(int core, int max, int keepAlive, int queueLength, String threadGroupName, String threadGroupId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Using backport of the util.concurrent package..");
        }
        this.executor = new ThreadPoolExecutor(core, max, (long)keepAlive, TimeUnit.SECONDS, (BlockingQueue)(queueLength == -1 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(queueLength)), (ThreadFactory)new BackportThreadFactory(new ThreadGroup(threadGroupName), threadGroupId));
    }

    public void execute(Runnable task) {
        this.executor.execute(task);
    }

    public class BackportThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger count = new AtomicInteger(1);
        final String namePrefix;

        public BackportThreadFactory(ThreadGroup group, String namePrefix) {
            this.group = group;
            this.namePrefix = namePrefix;
        }

        public Thread newThread(Runnable runnable) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.namePrefix);
            buffer.append('-');
            buffer.append(this.count.getAndIncrement());
            Thread t = new Thread(this.group, runnable, buffer.toString(), 0L);
            t.setDaemon(false);
            t.setPriority(5);
            return t;
        }
    }
}

