/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.nhttp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.params.HttpParams;
import org.apache.synapse.transport.nhttp.HostnameVerifier;
import org.apache.synapse.transport.nhttp.HttpCoreNIOSender;
import org.apache.synapse.transport.nhttp.SSLClientIOEventDispatch;

public class HttpCoreNIOSSLSender
extends HttpCoreNIOSender {
    private static final Log log = LogFactory.getLog(HttpCoreNIOSSLSender.class);

    protected IOEventDispatch getEventDispatch(NHttpClientHandler handler, SSLContext sslContext, SSLIOSessionHandler sslIOSessionHandler, HttpParams params) {
        return new SSLClientIOEventDispatch(handler, sslContext, sslIOSessionHandler, params);
    }

    protected SSLContext getSSLContext(TransportOutDescription transportOut) throws AxisFault {
        String storePassword;
        String type;
        String location;
        KeyManager[] keymanagers = null;
        TrustManager[] trustManagers = null;
        Parameter keyParam = transportOut.getParameter("keystore");
        Parameter trustParam = transportOut.getParameter("truststore");
        if (keyParam != null) {
            OMElement ksEle = keyParam.getParameterElement().getFirstElement();
            location = ksEle.getFirstChildWithName(new QName("Location")).getText();
            type = ksEle.getFirstChildWithName(new QName("Type")).getText();
            storePassword = ksEle.getFirstChildWithName(new QName("Password")).getText();
            String keyPassword = ksEle.getFirstChildWithName(new QName("KeyPassword")).getText();
            try {
                KeyStore keyStore = KeyStore.getInstance(type);
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(location);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading Key Store from URL : " + url));
                }
                keyStore.load(url.openStream(), storePassword.toCharArray());
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(keyStore, keyPassword.toCharArray());
                keymanagers = kmfactory.getKeyManagers();
            }
            catch (GeneralSecurityException gse) {
                log.error((Object)("Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                log.error((Object)("Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, (Throwable)ioe);
            }
        }
        if (trustParam != null) {
            OMElement tsEle = trustParam.getParameterElement().getFirstElement();
            location = tsEle.getFirstChildWithName(new QName("Location")).getText();
            type = tsEle.getFirstChildWithName(new QName("Type")).getText();
            storePassword = tsEle.getFirstChildWithName(new QName("Password")).getText();
            try {
                KeyStore trustStore = KeyStore.getInstance(type);
                URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(location);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loading Trust Key Store from URL : " + url));
                }
                trustStore.load(url.openStream(), storePassword.toCharArray());
                TrustManagerFactory trustManagerfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerfactory.init(trustStore);
                trustManagers = trustManagerfactory.getTrustManagers();
            }
            catch (GeneralSecurityException gse) {
                log.error((Object)("Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, (Throwable)gse);
            }
            catch (IOException ioe) {
                log.error((Object)("Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, (Throwable)ioe);
            }
        }
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(keymanagers, trustManagers, null);
            return sslcontext;
        }
        catch (GeneralSecurityException gse) {
            log.error((Object)"Unable to create SSL context with the given configuration", (Throwable)gse);
            throw new AxisFault("Unable to create SSL context with the given configuration", (Throwable)gse);
        }
    }

    protected SSLIOSessionHandler getSSLIOSessionHandler(TransportOutDescription transportOut) throws AxisFault {
        final Parameter hostnameVerifier = transportOut.getParameter("HostnameVerifier");
        return new SSLIOSessionHandler(){

            public void initalize(SSLEngine sslengine, HttpParams params) {
            }

            public void verify(SocketAddress remoteAddress, SSLSession session) throws SSLException {
                String address = null;
                address = remoteAddress instanceof InetSocketAddress ? ((InetSocketAddress)remoteAddress).getHostName() : remoteAddress.toString();
                boolean valid = false;
                if (hostnameVerifier != null) {
                    if ("Strict".equals(hostnameVerifier.getValue())) {
                        valid = HostnameVerifier.STRICT.verify(address, session);
                    } else if ("AllowAll".equals(hostnameVerifier.getValue())) {
                        valid = HostnameVerifier.ALLOW_ALL.verify(address, session);
                    } else if ("DefaultAndLocalhost".equals(hostnameVerifier.getValue())) {
                        valid = HostnameVerifier.DEFAULT_AND_LOCALHOST.verify(address, session);
                    }
                } else {
                    valid = HostnameVerifier.DEFAULT.verify(address, session);
                }
                if (!valid) {
                    throw new SSLException("Host name verification failed for host : " + address);
                }
            }
        };
    }
}

