/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.jms;

import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.jms.AxisJMSException;
import org.apache.synapse.transport.jms.JMSConnectionFactory;
import org.apache.synapse.transport.jms.JMSUtils;

public class JMSOutTransportInfo
implements OutTransportInfo {
    private static final Log log = LogFactory.getLog(JMSOutTransportInfo.class);
    private ConnectionFactory connectionFactory = null;
    private JMSConnectionFactory jmsConnectionFactory = null;
    private Destination destination = null;
    private String destinationType = null;
    private Hashtable properties = null;
    private String targetEPR = null;
    private String contentType = null;

    JMSOutTransportInfo(ConnectionFactory connectionFactory, Destination dest) {
        this.connectionFactory = connectionFactory;
        this.destination = dest;
    }

    JMSOutTransportInfo(JMSConnectionFactory jmsConnectionFactory, Destination dest) {
        this.jmsConnectionFactory = jmsConnectionFactory;
        this.destination = dest;
    }

    JMSOutTransportInfo(String targetEPR) {
        this.targetEPR = targetEPR;
        if (!targetEPR.startsWith("jms:/")) {
            this.handleException("Invalid prefix for a JMS EPR : " + targetEPR);
        } else {
            this.properties = JMSUtils.getProperties(targetEPR);
            String destinationType = (String)this.properties.get("transport.jms.DestinationType");
            this.setDestinationType(destinationType);
        }
    }

    public void loadConnectionFactoryFromProperies() {
        if (this.properties != null) {
            InitialContext context = null;
            try {
                context = new InitialContext(this.properties);
            }
            catch (NamingException e) {
                this.handleException("Could not get an initial context using " + this.properties, e);
            }
            this.connectionFactory = this.getConnectionFactory(context, this.properties);
            this.destination = this.getDestination(context, this.targetEPR);
        }
    }

    private ConnectionFactory getConnectionFactory(Context context, Hashtable props) {
        try {
            String conFacJndiName = (String)props.get("transport.jms.ConnectionFactoryJNDIName");
            if (conFacJndiName != null) {
                return (ConnectionFactory)context.lookup(conFacJndiName);
            }
            this.handleException("Connection Factory JNDI name cannot be determined");
        }
        catch (NamingException e) {
            this.handleException("Connection Factory JNDI name cannot be determined");
        }
        return null;
    }

    private Destination getDestination(Context context, String url) {
        String destinationName = JMSUtils.getDestination(url);
        try {
            return (Destination)context.lookup(destinationName);
        }
        catch (NameNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot locate destination : " + destinationName + " using " + url));
            }
        }
        catch (NamingException e) {
            this.handleException("Cannot locate destination : " + destinationName + " using " + url, e);
        }
        return null;
    }

    public Destination getReplyDestination(String replyDest) {
        try {
            return (Destination)this.jmsConnectionFactory.getContext().lookup(replyDest);
        }
        catch (NameNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot locate reply destination : " + replyDest), (Throwable)e);
            }
        }
        catch (NamingException e) {
            this.handleException("Cannot locate reply destination : " + replyDest, e);
        }
        return null;
    }

    private void handleException(String s) {
        log.error((Object)s);
        throw new AxisJMSException(s);
    }

    private void handleException(String s, Exception e) {
        log.error((Object)s, (Throwable)e);
        throw new AxisJMSException(s, e);
    }

    public Destination getDestination() {
        return this.destination;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public JMSConnectionFactory getJmsConnectionFactory() {
        return this.jmsConnectionFactory;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public String getTargetEPR() {
        return this.targetEPR;
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }
}

