/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.base.BaseConstants;
import org.apache.synapse.transport.base.BaseUtils;
import org.apache.synapse.transport.base.threads.WorkerPool;
import org.apache.synapse.transport.jms.AxisJMSException;
import org.apache.synapse.transport.jms.JMSConnectionFactory;
import org.apache.synapse.transport.jms.JMSListener;
import org.apache.synapse.transport.jms.JMSOutTransportInfo;
import org.apache.synapse.transport.jms.JMSUtils;

public class JMSMessageReceiver
implements MessageListener {
    private static final Log log = LogFactory.getLog(JMSMessageReceiver.class);
    private JMSListener jmsListener = null;
    private WorkerPool workerPool = null;
    private ConfigurationContext cfgCtx = null;
    private JMSConnectionFactory jmsConnectionFactory = null;

    JMSMessageReceiver(JMSListener jmsListener, JMSConnectionFactory jmsConFac, WorkerPool workerPool, ConfigurationContext cfgCtx) {
        this.jmsListener = jmsListener;
        this.jmsConnectionFactory = jmsConFac;
        this.workerPool = workerPool;
        this.cfgCtx = cfgCtx;
    }

    public void onMessage(Message message) {
        block8: {
            try {
                if (log.isDebugEnabled()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Received JMS message to destination : " + message.getJMSDestination());
                    sb.append("\nMessage ID : " + message.getJMSMessageID());
                    sb.append("\nCorrelation ID : " + message.getJMSCorrelationID());
                    sb.append("\nReplyTo ID : " + message.getJMSReplyTo());
                    log.debug((Object)sb.toString());
                    if (log.isTraceEnabled() && message instanceof TextMessage) {
                        log.trace((Object)("\nMessage : " + ((TextMessage)message).getText()));
                    }
                }
            }
            catch (JMSException e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)"Error reading JMS message headers for debug logging", (Throwable)e);
            }
        }
        try {
            long expiryTime = message.getJMSExpiration();
            if (expiryTime > 0L && System.currentTimeMillis() > expiryTime) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Discard expired message with ID : " + message.getJMSMessageID()));
                }
                return;
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        this.workerPool.execute(new Worker(message));
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new AxisJMSException(msg, e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new AxisJMSException(msg);
    }

    class Worker
    implements Runnable {
        private Message message = null;

        Worker(Message message) {
            this.message = message;
        }

        public void run() {
            MessageContext msgContext = JMSMessageReceiver.this.jmsListener.createMessageContext();
            try {
                msgContext.setMessageID(this.message.getJMSMessageID());
                msgContext.setProperty("JMS_COORELATION_ID", (Object)this.message.getJMSMessageID());
            }
            catch (JMSException ignore) {
                // empty catch block
            }
            try {
                Parameter param;
                Destination dest = this.message.getJMSDestination();
                String destinationName = null;
                if (dest instanceof Queue) {
                    destinationName = ((Queue)dest).getQueueName();
                } else if (dest instanceof Topic) {
                    destinationName = ((Topic)dest).getTopicName();
                }
                String serviceName = JMSMessageReceiver.this.jmsConnectionFactory.getServiceNameForDestination(dest, destinationName);
                String soapAction = JMSUtils.getInstace().getProperty(this.message, "SOAPAction");
                AxisService service = null;
                if (serviceName != null) {
                    service = JMSMessageReceiver.this.cfgCtx.getAxisConfiguration().getService(serviceName);
                    msgContext.setAxisService(service);
                    Parameter operationParam = service.getParameter("Operation");
                    QName operationQName = operationParam != null ? BaseUtils.getQNameFromString(operationParam.getValue()) : BaseConstants.DEFAULT_OPERATION;
                    AxisOperation operation = service.getOperation(operationQName);
                    if (operation != null) {
                        msgContext.setAxisOperation(operation);
                        msgContext.setSoapAction("urn:" + operation.getName().getLocalPart());
                    }
                }
                if (this.message.getJMSReplyTo() != null) {
                    msgContext.setProperty("OutTransportInfo", (Object)new JMSOutTransportInfo(JMSMessageReceiver.this.jmsConnectionFactory, this.message.getJMSReplyTo()));
                } else if (service != null && (param = service.getParameter("transport.jms.ReplyDestination")) != null && param.getValue() != null) {
                    msgContext.setProperty("OutTransportInfo", (Object)new JMSOutTransportInfo(JMSMessageReceiver.this.jmsConnectionFactory, JMSMessageReceiver.this.jmsConnectionFactory.getDestination((String)param.getValue())));
                }
                String contentType = JMSUtils.getInstace().getProperty(this.message, "Content-Type");
                JMSUtils.getInstace().setSOAPEnvelope(this.message, msgContext, contentType);
                JMSMessageReceiver.this.jmsListener.handleIncomingMessage(msgContext, JMSUtils.getTransportHeaders(this.message), soapAction, contentType);
            }
            catch (JMSException e) {
                JMSMessageReceiver.this.handleException("JMS Exception reading the message Destination or JMS ReplyTo", (Exception)((Object)e));
            }
            catch (AxisFault e) {
                JMSMessageReceiver.this.handleException("Axis fault creating a MessageContext", (Exception)((Object)e));
            }
        }
    }
}

