/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.MessageSender;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelSender
implements MessageSender {
    private Log log = LogFactory.getLog((Class)ChannelSender.class);
    private Channel channel;

    public void sendToGroup(ClusteringCommand msg) throws ClusteringFault {
        if (this.channel == null) {
            return;
        }
        long timeToSend = 0L;
        Member[] members = MembershipManager.getMembers();
        if (members.length > 0) {
            try {
                long start = System.currentTimeMillis();
                this.channel.send(members, (Serializable)this.toByteMessage(msg), 6);
                timeToSend = System.currentTimeMillis() - start;
                this.log.debug((Object)("Sent " + msg + " to group"));
            }
            catch (NotSerializableException e) {
                String message = "Could not send command message " + msg + " to group since it is not serializable.";
                this.log.error((Object)message, (Throwable)e);
                throw new ClusteringFault(message, (Exception)e);
            }
            catch (ChannelException e) {
                this.log.error((Object)"Could not send message to some members", (Throwable)e);
            }
            catch (Exception e) {
                String message = "Error sending command message : " + msg + ". Reason " + e.getMessage();
                this.log.warn((Object)message, (Throwable)e);
            }
        }
    }

    private ByteMessage toByteMessage(ClusteringCommand msg) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(msg);
        out.flush();
        out.close();
        return new ByteMessage(bos.toByteArray());
    }

    public void sendToSelf(ClusteringCommand msg) throws ClusteringFault {
        if (this.channel == null) {
            return;
        }
        try {
            this.channel.send(new Member[]{this.channel.getLocalMember(true)}, (Serializable)this.toByteMessage(msg), 2);
            this.log.debug((Object)("Sent " + msg + " to self"));
        }
        catch (Exception e) {
            throw new ClusteringFault(e);
        }
    }

    public long sendToMember(ClusteringCommand cmd, Member member) throws ClusteringFault {
        long timeToSend = 0L;
        try {
            if (member.isReady()) {
                long start = System.currentTimeMillis();
                this.channel.send(new Member[]{member}, (Serializable)this.toByteMessage(cmd), 6);
                timeToSend = System.currentTimeMillis() - start;
                this.log.debug((Object)("Sent " + cmd + " to " + TribesUtil.getHost(member)));
            }
        }
        catch (NotSerializableException e) {
            String message = "Could not send command message to " + TribesUtil.getHost(member) + " since it is not serializable.";
            this.log.error((Object)message, (Throwable)e);
            throw new ClusteringFault(message, (Exception)e);
        }
        catch (ChannelException e) {
            this.log.error((Object)("Could not send message to " + TribesUtil.getHost(member)));
        }
        catch (Exception e) {
            String message = "Could not send message to " + TribesUtil.getHost(member) + ". Reason " + e.getMessage();
            this.log.warn((Object)message, (Throwable)e);
        }
        return timeToSend;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }
}

