/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.configuration.ConfigurationClusteringCommand;
import org.apache.axis2.clustering.configuration.DefaultConfigurationManager;
import org.apache.axis2.clustering.context.ContextClusteringCommand;
import org.apache.axis2.clustering.context.DefaultContextManager;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.clustering.control.GetConfigurationResponseCommand;
import org.apache.axis2.clustering.control.GetStateResponseCommand;
import org.apache.axis2.clustering.tribes.ChannelSender;
import org.apache.axis2.clustering.tribes.TribesControlCommandProcessor;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChannelListener
implements org.apache.catalina.tribes.ChannelListener {
    private static final Log log = LogFactory.getLog((Class)ChannelListener.class);
    private static final int TIME_TO_LIVE = 300000;
    private DefaultContextManager contextManager;
    private DefaultConfigurationManager configurationManager;
    private TribesControlCommandProcessor controlCommandProcessor;
    private ChannelSender channelSender;
    private ConfigurationContext configurationContext;
    private boolean synchronizeAllMembers;
    private Map receivedMessages = new HashMap();

    public ChannelListener(ConfigurationContext configurationContext, DefaultConfigurationManager configurationManager, DefaultContextManager contextManager, TribesControlCommandProcessor controlCommandProcessor, ChannelSender sender, boolean synchronizeAllMembers) {
        this.configurationManager = configurationManager;
        this.contextManager = contextManager;
        this.controlCommandProcessor = controlCommandProcessor;
        this.channelSender = sender;
        this.configurationContext = configurationContext;
        this.synchronizeAllMembers = synchronizeAllMembers;
        Timer cleanupTimer = new Timer();
        cleanupTimer.scheduleAtFixedRate((TimerTask)new ReceivedMessageCleanupTask(), 300000L, 300000L);
    }

    public void setContextManager(DefaultContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public void setConfigurationManager(DefaultConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public boolean accept(Serializable msg, Member sender) {
        return this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") != null;
    }

    public void messageReceived(Serializable msg, Member sender) {
        try {
            AxisConfiguration configuration = this.configurationContext.getAxisConfiguration();
            ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
            classLoaders.add(configuration.getSystemClassLoader());
            classLoaders.add(this.getClass().getClassLoader());
            Iterator iter = configuration.getServiceGroups();
            while (iter.hasNext()) {
                AxisServiceGroup group = (AxisServiceGroup)iter.next();
                classLoaders.add(group.getServiceGroupClassLoader());
            }
            iter = configuration.getModules().values().iterator();
            while (iter.hasNext()) {
                AxisModule module = (AxisModule)iter.next();
                classLoaders.add(module.getModuleClassLoader());
            }
            byte[] message = ((ByteMessage)msg).getMessage();
            msg = XByteBuffer.deserialize((byte[])message, (int)0, (int)message.length, (ClassLoader[])classLoaders.toArray(new ClassLoader[classLoaders.size()]));
        }
        catch (Exception e) {
            log.error((Object)"Cannot deserialize received message", (Throwable)e);
            return;
        }
        if (this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null && !(msg instanceof GetStateResponseCommand) && !(msg instanceof GetConfigurationResponseCommand)) {
            log.warn((Object)("Received message " + msg + " before cluster initialization has been completed from " + TribesUtil.getHost(sender)));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received message " + msg + " from " + TribesUtil.getHost(sender)));
        }
        try {
            this.processMessage(msg, sender);
        }
        catch (Exception e) {
            log.error((Object)"Cannot process message", (Throwable)e);
        }
    }

    private void processMessage(Serializable msg, Member sender) throws ClusteringFault {
        if (msg instanceof ContextClusteringCommand && this.contextManager != null) {
            ContextClusteringCommand ctxCmd = (ContextClusteringCommand)msg;
            ctxCmd.execute(this.configurationContext);
        } else if (msg instanceof ConfigurationClusteringCommand && this.configurationManager != null) {
            this.configurationManager.process((ConfigurationClusteringCommand)msg);
        } else if (msg instanceof ControlCommand && this.controlCommandProcessor != null) {
            this.controlCommandProcessor.process((ControlCommand)((Object)msg), sender);
        }
    }

    private class ReceivedMessageCleanupTask
    extends TimerTask {
        private ReceivedMessageCleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<String> toBeRemoved = new ArrayList<String>();
            Map map = ChannelListener.this.receivedMessages;
            synchronized (map) {
                String msgId;
                Iterator<Object> iter = ChannelListener.this.receivedMessages.keySet().iterator();
                while (iter.hasNext()) {
                    msgId = (String)iter.next();
                    Long recdTime = (Long)ChannelListener.this.receivedMessages.get(msgId);
                    if (System.currentTimeMillis() - recdTime < 300000L) continue;
                    toBeRemoved.add(msgId);
                }
                iter = toBeRemoved.iterator();
                while (iter.hasNext()) {
                    msgId = (String)iter.next();
                    ChannelListener.this.receivedMessages.remove(msgId);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Removed message " + msgId + " from received message buffer"));
                }
            }
        }
    }
}

