/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.util.om;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.woden.ErrorLocator;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.ErrorLocatorImpl;
import org.apache.woden.internal.ErrorReporterImpl;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.xml.sax.InputSource;

public class OMUtils {
    public static StAXOMBuilder getOMBuilder(String strUri) throws IOException {
        StAXOMBuilder builder = null;
        try {
            URI uri = new URI(strUri);
            URL url = uri.toURL();
            InputStream in = url.openStream();
            builder = new StAXOMBuilder(in);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return builder;
    }

    public static OMElement getElement(String uri) throws IOException {
        StAXOMBuilder builder = OMUtils.getOMBuilder(uri);
        return builder == null ? null : builder.getDocumentElement();
    }

    public static String getAttribute(OMElement omElement, String attrName) {
        String val = null;
        Iterator allAttr = omElement.getAllAttributes();
        while (allAttr.hasNext()) {
            OMAttribute attr = (OMAttribute)allAttr.next();
            if (!attr.getLocalName().equals(attrName)) continue;
            val = attr.getAttributeValue();
        }
        return val;
    }

    public static InputSource getInputSource(OMElement element) {
        byte[] bytes = new byte[]{};
        try {
            String elementString = element.toStringWithConsume();
            bytes = elementString.getBytes();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return new InputSource(inputStream);
    }

    public static QName getQName(String prefixedValue, OMElement contextEl) throws WSDLException {
        int index = prefixedValue.indexOf(58);
        String prefix = index != -1 ? prefixedValue.substring(0, index) : null;
        String localPart = prefixedValue.substring(index + 1);
        if (prefix != null) {
            String namespaceURI = contextEl.findNamespaceURI(prefix).getNamespaceURI();
            return new QName(namespaceURI, localPart, prefix);
        }
        String faultCode = "NO_PREFIX_SPECIFIED";
        throw new WSDLException(faultCode, "Unable to determine namespace of '" + prefixedValue + "'.");
    }

    public static String getAttributeNS(OMElement el, String namespaceURI, String localPart) {
        String sRet = null;
        OMAttribute attr = el.getAttribute(new QName(namespaceURI, localPart));
        if (attr != null) {
            sRet = attr.getAttributeValue();
        }
        return sRet;
    }

    public static void registerUniquePrefix(String prefix, String namespaceURI, DescriptionElement desc) throws WSDLException {
        String tempNSUri;
        URI nsUri = desc.getNamespace(prefix);
        String string = tempNSUri = nsUri != null ? nsUri.toString() : null;
        if (tempNSUri != null && tempNSUri.equals(namespaceURI)) {
            return;
        }
        while (tempNSUri != null && !tempNSUri.equals(namespaceURI)) {
            nsUri = desc.getNamespace(prefix = prefix + "_");
            tempNSUri = nsUri != null ? nsUri.toString() : null;
        }
        URI uri = null;
        try {
            uri = new URI(namespaceURI);
        }
        catch (URISyntaxException e) {
            new ErrorReporterImpl().reportError((ErrorLocator)new ErrorLocatorImpl(), "WSDL506", new Object[]{namespaceURI}, (short)2, (Exception)e);
        }
        desc.addNamespace(prefix, uri);
    }
}

