/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.resolver;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.woden.WSDLException;
import org.apache.woden.internal.util.PropertyUtils;
import org.apache.woden.resolver.URIResolver;

public class SimpleURIResolver
implements URIResolver {
    private static final String RESOLVER_PROPERTIES_PROPERTY = "org.apache.woden.resolver.simpleresolver.catalog";
    private static final String RESOLVER_BASE_PROPERTY = "org.apache.woden.resolver.simpleresolver.baseURIs";
    private final String userCatalogFile = PropertyUtils.findProperty("org.apache.woden.resolver.simpleresolver.catalog");
    private final String rootURLsList = PropertyUtils.findProperty("org.apache.woden.resolver.simpleresolver.baseURIs");
    private final String schemaCatalogFile = "schema.catalog";
    private final String schemaCatalogLocation = "META-INF/";
    private Hashtable uriTable = null;
    private static final String RESOLVER_LOGGING_PROPERTY = "org.apache.woden.resolver.logging";
    private static final String LOGGING_ON = "on";
    private final String loggingRequest = PropertyUtils.findProperty("org.apache.woden.resolver.logging");
    private boolean logging;

    public SimpleURIResolver() throws WSDLException {
        Properties schemaCatalog = null;
        Properties userCatalog = null;
        this.logging = LOGGING_ON.equalsIgnoreCase(this.loggingRequest);
        ClassLoader systemLoader = this.getClass().getClassLoader();
        URL schemaCatalogURL = systemLoader.getResource("META-INF/schema.catalog");
        if (schemaCatalogURL == null) {
            schemaCatalogURL = systemLoader.getResource("schema.catalog");
        }
        schemaCatalog = this.loadCatalog(schemaCatalogURL);
        if (this.userCatalogFile != null) {
            try {
                userCatalog = this.loadCatalog(new URL(this.userCatalogFile));
            }
            catch (MalformedURLException e) {
                throw new WSDLException("CONFIGURATION_ERROR", "Problem locating the URI resolver user catalog: " + this.userCatalogFile, e);
            }
        }
        URL[] rootURLs = this.urlPathList(this.rootURLsList);
        URLClassLoader userLoader = new URLClassLoader(rootURLs, systemLoader);
        try {
            Hashtable interrimUriTable = this.toURI(schemaCatalog, systemLoader);
            this.uriTable = this.toURI(userCatalog, userLoader, interrimUriTable);
        }
        catch (URISyntaxException e) {
            throw new WSDLException("CONFIGURATION_ERROR", "Problem instantiating the URI resolution table.", e);
        }
    }

    private Properties loadCatalog(URL catalogLocation) {
        return this.loadCatalog(catalogLocation, new Properties());
    }

    private Properties loadCatalog(URL catalogLocation, Properties catalog) {
        if (catalogLocation != null) {
            URI catalogURI = null;
            try {
                catalogURI = new URI(catalogLocation.toString());
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
            try {
                if (catalogURI != null) {
                    catalog.load(catalogURI.toURL().openStream());
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return catalog;
    }

    private URL[] urlPathList(String rootURLs) throws WSDLException {
        if (rootURLs == null || rootURLs.length() == 0) {
            return new URL[0];
        }
        String[] urlStrings = rootURLs.split(";");
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < urlStrings.length; ++i) {
            try {
                URL url = new URL(urlStrings[i]);
                urls.add(url);
                continue;
            }
            catch (MalformedURLException e) {
                throw new WSDLException("CONFIGURATION_ERROR", "Invalid URL '" + urlStrings[i] + "' in base URL list '" + rootURLs + "'", e);
            }
        }
        return urls.toArray(new URL[0]);
    }

    public URI resolveURI(URI uri) throws WSDLException {
        URI resolvedURI = null;
        if (this.uriTable.containsKey(uri)) {
            resolvedURI = (URI)this.uriTable.get(uri);
            this.logResolve(uri, resolvedURI);
        } else {
            this.logNoResolve(uri);
        }
        return resolvedURI;
    }

    private void logNoResolve(URI uri) {
        if (this.logging) {
            System.out.println("resolver:NO:  URI " + uri + " did not resolve");
        }
    }

    private void logResolve(URI uri, URI resolvedURI) {
        if (this.logging) {
            System.out.println("resolver:YES: URI " + uri + " successfully resolved to URI " + resolvedURI);
        }
    }

    private Hashtable toURI(Properties p, ClassLoader loader) throws URISyntaxException {
        return this.toURI(p, loader, new Hashtable());
    }

    private Hashtable toURI(Properties p, ClassLoader loader, Hashtable h) throws URISyntaxException {
        if (p != null) {
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = p.getProperty(key);
                try {
                    URI valueURI = new URI(value);
                    if (!valueURI.isAbsolute()) {
                        URL valueURL = loader.getResource(value);
                        if (valueURL != null) {
                            valueURI = new URI(valueURL.toString());
                            h.put(new URI(key), valueURI);
                            continue;
                        }
                        System.out.println("Lookup failed for URL " + value);
                        continue;
                    }
                    h.put(new URI(key), valueURI);
                }
                catch (URISyntaxException e) {
                    System.out.println("Invalid URL " + value + ": " + e.getMessage());
                }
            }
        }
        return h;
    }
}

