/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description.java2wsdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JField;
import org.codehaus.jam.JMethod;
import org.codehaus.jam.JParameter;
import org.codehaus.jam.JProperty;

public class DocLitBareSchemaGenerator
extends DefaultSchemaGenerator {
    private static final Log log = LogFactory.getLog((Class)DocLitBareSchemaGenerator.class);
    private HashMap processedParameters = new HashMap();

    public DocLitBareSchemaGenerator(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix, AxisService service) throws Exception {
        super(loader, className, schematargetNamespace, schematargetNamespacePrefix, service);
    }

    protected JMethod[] processMethods(JMethod[] declaredMethods) throws Exception {
        ArrayList<JMethod> list = new ArrayList<JMethod>();
        Arrays.sort(declaredMethods);
        HashMap<String, JMethod> uniqueMethods = new HashMap<String, JMethod>();
        for (int i = 0; i < declaredMethods.length; ++i) {
            JClass returnType;
            JParameter methodParameter;
            XmlSchemaComplexType methodSchemaType;
            XmlSchemaSequence sequence;
            JMethod jMethod = declaredMethods[i];
            JAnnotation methodAnnon = jMethod.getAnnotation("javax.jws.WebMethod");
            if (methodAnnon != null && methodAnnon.getValue("exclude").asBoolean()) continue;
            String methodName = this.getSimpleName(jMethod);
            if (this.excludeMethods.contains(this.getSimpleName(jMethod))) continue;
            if (uniqueMethods.get(this.getSimpleName(jMethod)) != null) {
                log.warn((Object)("We don't support method overloading. Ignoring [" + jMethod.getQualifiedName() + "]"));
                continue;
            }
            if (!jMethod.isPublic()) continue;
            boolean addToService = false;
            AxisOperation axisOperation = this.service.getOperation(new QName(methodName));
            if (axisOperation == null) {
                AxisMessage outMessage;
                axisOperation = Utils.getAxisOperationForJmethod(jMethod);
                if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(axisOperation.getMessageExchangePattern()) && (outMessage = axisOperation.getMessage("Out")) != null) {
                    outMessage.setName(methodName + "Result");
                }
                addToService = true;
            }
            list.add(jMethod);
            this.processException(jMethod, axisOperation);
            uniqueMethods.put(this.getSimpleName(jMethod), jMethod);
            uniqueMethods.put(this.getSimpleName(jMethod), jMethod);
            JParameter[] paras = jMethod.getParameters();
            String[] parameterNames = this.methodTable.getParameterNames(methodName);
            AxisMessage inMessage = axisOperation.getMessage("In");
            if (inMessage != null) {
                inMessage.setName(methodName + "RequestMessage");
            }
            if (paras.length > 1) {
                sequence = new XmlSchemaSequence();
                methodSchemaType = this.createSchemaTypeForMethodPart(this.getSimpleName(jMethod));
                methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                inMessage.setElementQName(this.typeTable.getQNamefortheType(methodName));
                this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
                inMessage.setPartName(methodName);
                for (int j = 0; j < paras.length && !this.generateRequestSchema(methodParameter = paras[j], parameterNames, j, jMethod, sequence); ++j) {
                }
            } else if (paras.length == 1) {
                if (paras[0].getType().isArrayType()) {
                    sequence = new XmlSchemaSequence();
                    methodSchemaType = this.createSchemaTypeForMethodPart(methodName);
                    methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                    JParameter methodParameter2 = paras[0];
                    inMessage.setElementQName(this.typeTable.getQNamefortheType(methodName));
                    this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
                    inMessage.setPartName(methodName);
                    if (this.generateRequestSchema(methodParameter2, parameterNames, 0, jMethod, sequence)) {
                        break;
                    }
                } else {
                    JMethod processMethod;
                    String parameterName = null;
                    methodParameter = paras[0];
                    JAnnotation paramterAnnon = methodParameter.getAnnotation("javax.jws.WebParam");
                    if (paramterAnnon != null) {
                        parameterName = paramterAnnon.getValue("name").asString();
                    }
                    if (parameterName == null || "".equals(parameterName)) {
                        String string = parameterName = parameterNames != null && parameterNames[0] != null ? parameterNames[0] : this.getSimpleName(methodParameter);
                    }
                    if ((processMethod = (JMethod)this.processedParameters.get(parameterName)) != null) {
                        throw new AxisFault("Inavalid Java class, there are two methods [" + processMethod.getSimpleName() + " and " + jMethod.getSimpleName() + " ]which have the same parameter names");
                    }
                    this.processedParameters.put(parameterName, jMethod);
                    this.generateSchemaForType(null, paras[0].getType(), parameterName);
                    inMessage.setElementQName(this.typeTable.getQNamefortheType(parameterName));
                    inMessage.setPartName(parameterName);
                    inMessage.setWrapped(false);
                    this.service.addMessageElementQNameToOperationMapping(this.typeTable.getQNamefortheType(parameterName), axisOperation);
                }
            }
            if (!(returnType = jMethod.getReturnType()).isVoidType()) {
                AxisMessage outMessage = axisOperation.getMessage("Out");
                if (returnType.isArrayType()) {
                    methodSchemaType = this.createSchemaTypeForMethodPart(this.getSimpleName(jMethod) + "Result");
                    sequence = new XmlSchemaSequence();
                    methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                    JAnnotation returnAnnon = jMethod.getAnnotation("javax.jws.WebResult");
                    String returnName = "return";
                    if (returnAnnon != null && (returnName = returnAnnon.getValue("name").asString()) != null && !"".equals(returnName)) {
                        returnName = "return";
                    }
                    if (this.nonRpcMethods.contains(methodName)) {
                        this.generateSchemaForType(sequence, null, returnName);
                    } else {
                        this.generateSchemaForType(sequence, returnType, returnName);
                    }
                } else {
                    this.generateSchemaForType(null, returnType, methodName + "Result");
                    outMessage.setWrapped(false);
                }
                outMessage.setElementQName(this.typeTable.getQNamefortheType(methodName + "Result"));
                outMessage.setName(methodName + "ResponseMessage");
                outMessage.setPartName(methodName + "Result");
                this.service.addMessageElementQNameToOperationMapping(this.typeTable.getQNamefortheType(methodName + "Result"), axisOperation);
            }
            if (!addToService) continue;
            this.service.addOperation(axisOperation);
        }
        return list.toArray(new JMethod[list.size()]);
    }

    private boolean generateRequestSchema(JParameter methodParameter, String[] parameterNames, int j, JMethod jMethod, XmlSchemaSequence sequence) throws Exception {
        String parameterName = null;
        JAnnotation paramterAnnon = methodParameter.getAnnotation("javax.jws.WebParam");
        if (paramterAnnon != null) {
            parameterName = paramterAnnon.getValue("name").asString();
        }
        if (parameterName == null || "".equals(parameterName)) {
            parameterName = parameterNames != null && parameterNames[j] != null ? parameterNames[j] : this.getSimpleName(methodParameter);
        }
        JClass paraType = methodParameter.getType();
        if (this.nonRpcMethods.contains(this.getSimpleName(jMethod))) {
            this.generateSchemaForType(sequence, null, this.getSimpleName(jMethod));
            return true;
        }
        this.generateSchemaForType(sequence, paraType, parameterName);
        return false;
    }

    private QName generateSchemaForType(XmlSchemaSequence sequence, JClass type, String partName) throws Exception {
        QName schemaTypeName;
        boolean isArrayType = false;
        if (type != null) {
            isArrayType = type.isArrayType();
        }
        if (isArrayType) {
            type = type.getArrayComponentType();
        }
        if (AxisFault.class.getName().equals(type)) {
            return null;
        }
        String classTypeName = type == null ? "java.lang.Object" : this.getQualifiedName(type);
        if (isArrayType && "byte".equals(classTypeName)) {
            classTypeName = "base64Binary";
            isArrayType = false;
        }
        if (this.isDataHandler(type)) {
            classTypeName = "base64Binary";
        }
        if ((schemaTypeName = this.typeTable.getSimpleSchemaTypeName(classTypeName)) == null && type != null) {
            schemaTypeName = this.generateSchema(type);
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
            String schemaNamespace = this.resolveSchemaNamespace(this.getQualifiedName(type.getContainingPackage()));
            this.addImport(this.getXmlSchema(schemaNamespace), schemaTypeName);
            if (sequence == null) {
                this.generateSchemaForSingleElement(schemaTypeName, partName, isArrayType, type);
            }
        } else if (sequence == null) {
            this.generateSchemaForSingleElement(schemaTypeName, partName, isArrayType, type);
        } else {
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
        }
        return schemaTypeName;
    }

    protected void generateSchemaForSingleElement(QName schemaTypeName, String paraName, boolean isArray, JClass javaType) throws Exception {
        XmlSchemaElement elt1 = new XmlSchemaElement();
        elt1.setName(paraName);
        elt1.setSchemaTypeName(schemaTypeName);
        elt1.setNillable(true);
        QName elementName = new QName(this.schemaTargetNameSpace, paraName, this.schema_namespace_prefix);
        elt1.setQName(elementName);
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        xmlSchema.getElements().add(elementName, (XmlSchemaObject)elt1);
        xmlSchema.getItems().add((XmlSchemaObject)elt1);
        this.typeTable.addComplexSchema(paraName, elementName);
    }

    private QName generateSchema(JClass javaType) throws Exception {
        String name = this.getQualifiedName(javaType);
        QName schemaTypeName = this.typeTable.getComplexSchemaType(name);
        if (schemaTypeName == null) {
            int i;
            String simpleName = this.getSimpleName(javaType);
            String packageName = this.getQualifiedName(javaType.getContainingPackage());
            String targetNameSpace = this.resolveSchemaNamespace(packageName);
            XmlSchema xmlSchema = this.getXmlSchema(targetNameSpace);
            String targetNamespacePrefix = (String)this.targetNamespacePrefixMap.get(targetNameSpace);
            if (targetNamespacePrefix == null) {
                targetNamespacePrefix = this.generatePrefix();
                this.targetNamespacePrefixMap.put(targetNameSpace, targetNamespacePrefix);
            }
            XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaSequence sequence = new XmlSchemaSequence();
            XmlSchemaComplexContentExtension complexExtension = new XmlSchemaComplexContentExtension();
            XmlSchemaElement eltOuter = new XmlSchemaElement();
            schemaTypeName = new QName(targetNameSpace, simpleName, targetNamespacePrefix);
            eltOuter.setName(simpleName);
            eltOuter.setQName(schemaTypeName);
            JClass sup = javaType.getSuperclass();
            if (sup != null && "java.lang.Object".compareTo(sup.getQualifiedName()) != 0 && "org.apache.axis2".compareTo(sup.getContainingPackage().getQualifiedName()) != 0) {
                String tgtNamespacepfx;
                String tgtNamespace;
                String superClassName = sup.getQualifiedName();
                String superclassname = this.getSimpleName(sup);
                QName qName = this.typeTable.getSimpleSchemaTypeName(superClassName);
                if (qName != null) {
                    tgtNamespace = qName.getNamespaceURI();
                    tgtNamespacepfx = qName.getPrefix();
                } else {
                    tgtNamespace = this.resolveSchemaNamespace(sup.getContainingPackage().getQualifiedName());
                    tgtNamespacepfx = (String)this.targetNamespacePrefixMap.get(tgtNamespace);
                    QName superClassQname = this.generateSchema(sup);
                    if (superClassQname != null) {
                        tgtNamespacepfx = superClassQname.getPrefix();
                        tgtNamespace = superClassQname.getNamespaceURI();
                    }
                }
                if (tgtNamespacepfx == null) {
                    tgtNamespacepfx = this.generatePrefix();
                    this.targetNamespacePrefixMap.put(tgtNamespace, tgtNamespacepfx);
                }
                QName basetype = new QName(tgtNamespace, superclassname, tgtNamespacepfx);
                complexExtension.setBaseTypeName(basetype);
                complexExtension.setParticle((XmlSchemaParticle)sequence);
                XmlSchemaComplexContent contentModel = new XmlSchemaComplexContent();
                contentModel.setContent((XmlSchemaContent)complexExtension);
                complexType.setContentModel((XmlSchemaContentModel)contentModel);
            } else {
                complexType.setParticle((XmlSchemaParticle)sequence);
            }
            complexType.setName(simpleName);
            xmlSchema.getElements().add(schemaTypeName, (XmlSchemaObject)eltOuter);
            eltOuter.setSchemaTypeName(complexType.getQName());
            xmlSchema.getItems().add((XmlSchemaObject)complexType);
            xmlSchema.getSchemaTypes().add(schemaTypeName, (XmlSchemaObject)complexType);
            this.typeTable.addComplexSchema(name, eltOuter.getQName());
            this.typeTable.addComplexSchema(javaType.getContainingPackage().getQualifiedName(), eltOuter.getQName());
            HashSet<JProperty> propertiesSet = new HashSet<JProperty>();
            HashSet<String> propertiesNames = new HashSet<String>();
            JProperty[] tempProperties = javaType.getDeclaredProperties();
            for (int i2 = 0; i2 < tempProperties.length; ++i2) {
                propertiesSet.add(tempProperties[i2]);
            }
            Object[] properties = propertiesSet.toArray(new JProperty[0]);
            Arrays.sort(properties);
            for (int i3 = 0; i3 < properties.length; ++i3) {
                Object property = properties[i3];
                boolean isArryType = property.getType().isArrayType();
                String propname = DocLitBareSchemaGenerator.getCorrectName(property.getSimpleName());
                propertiesNames.add(propname);
                this.generateSchemaforFieldsandProperties(xmlSchema, sequence, property.getType(), propname, isArryType);
            }
            JField[] tempFields = javaType.getDeclaredFields();
            HashMap<String, JField> FieldMap = new HashMap<String, JField>();
            for (int i4 = 0; i4 < tempFields.length; ++i4) {
                if (!tempFields[i4].isPublic() || propertiesNames.contains(tempFields[i4].getSimpleName())) continue;
                FieldMap.put(tempFields[i4].getSimpleName(), tempFields[i4]);
            }
            for (JClass supr = javaType.getSuperclass(); supr != null && supr.getQualifiedName().compareTo("java.lang.Object") != 0; supr = supr.getSuperclass()) {
                JField[] suprFields = supr.getFields();
                for (i = 0; i < suprFields.length; ++i) {
                    FieldMap.remove(suprFields[i].getSimpleName());
                }
            }
            Object[] froperties = FieldMap.values().toArray(new JField[0]);
            Arrays.sort(froperties);
            for (i = 0; i < froperties.length; ++i) {
                Object field = froperties[i];
                boolean isArryType = field.getType().isArrayType();
                this.generateSchemaforFieldsandProperties(xmlSchema, sequence, field.getType(), field.getSimpleName(), isArryType);
            }
        }
        return schemaTypeName;
    }

    private XmlSchemaComplexType createSchemaTypeForMethodPart(String localPartName) {
        QName elementName;
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaComplexType complexType = this.getComplexTypeForElement(xmlSchema, elementName = new QName(this.schemaTargetNameSpace, localPartName, this.schema_namespace_prefix));
        if (complexType == null) {
            complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaElement globalElement = new XmlSchemaElement();
            globalElement.setSchemaType((XmlSchemaType)complexType);
            globalElement.setName(localPartName);
            globalElement.setQName(elementName);
            xmlSchema.getItems().add((XmlSchemaObject)globalElement);
            xmlSchema.getElements().add(elementName, (XmlSchemaObject)globalElement);
        }
        this.typeTable.addComplexSchema(localPartName, elementName);
        return complexType;
    }

    private XmlSchema getXmlSchema(String targetNamespace) {
        XmlSchema xmlSchema = (XmlSchema)this.schemaMap.get(targetNamespace);
        if (xmlSchema == null) {
            String targetNamespacePrefix = targetNamespace.equals(this.schemaTargetNameSpace) && this.schema_namespace_prefix != null ? this.schema_namespace_prefix : this.generatePrefix();
            xmlSchema = new XmlSchema(targetNamespace, this.xmlSchemaCollection);
            xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
            xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
            this.targetNamespacePrefixMap.put(targetNamespace, targetNamespacePrefix);
            this.schemaMap.put(targetNamespace, xmlSchema);
            NamespaceMap prefixmap = new NamespaceMap();
            prefixmap.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
            prefixmap.put((Object)targetNamespacePrefix, (Object)targetNamespace);
            xmlSchema.setNamespaceContext((NamespacePrefixList)prefixmap);
        }
        return xmlSchema;
    }
}

