/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context;

import java.util.ArrayList;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Replicator {
    private static final Log log = LogFactory.getLog((Class)Replicator.class);

    public static void replicate(MessageContext msgContext) throws ClusteringFault {
        if (!Replicator.doReplication(msgContext)) {
            return;
        }
        log.debug((Object)"Going to replicate state...");
        try {
            Replicator.replicateState(msgContext);
        }
        catch (Exception e) {
            String message = "Could not replicate the state";
            log.error((Object)message, (Throwable)e);
            throw new ClusteringFault(message, e);
        }
    }

    public static void replicate(AbstractContext abstractContext) throws ClusteringFault {
        if (!Replicator.doReplication(abstractContext)) {
            return;
        }
        log.debug((Object)"Going to replicate state...");
        try {
            Replicator.replicateState(abstractContext);
        }
        catch (Exception e) {
            String message = "Could not replicate the state";
            log.error((Object)message, (Throwable)e);
            throw new ClusteringFault(message, e);
        }
    }

    private static boolean doReplication(AbstractContext abstractContext) {
        ClusterManager clusterManager = abstractContext.getRootContext().getAxisConfiguration().getClusterManager();
        return clusterManager != null && clusterManager.getContextManager() != null;
    }

    private static void replicateState(AbstractContext abstractContext) throws ClusteringFault {
        ClusterManager clusterManager = abstractContext.getRootContext().getAxisConfiguration().getClusterManager();
        if (clusterManager != null) {
            ContextManager contextManager = clusterManager.getContextManager();
            if (contextManager == null) {
                String msg = "Cannot replicate contexts since ContextManager is not specified in the axis2.xml file.";
                throw new ClusteringFault(msg);
            }
            if (!abstractContext.getPropertyDifferences().isEmpty()) {
                String msgUUID = contextManager.updateContext(abstractContext);
                Replicator.waitForACKs(contextManager, msgUUID, abstractContext.getRootContext());
            }
        } else {
            String msg = "Cannot replicate contexts since ClusterManager is not specified in the axis2.xml file.";
            throw new ClusteringFault(msg);
        }
    }

    private static void replicateState(MessageContext msgContext) throws ClusteringFault {
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        ClusterManager clusterManager = axisConfiguration.getClusterManager();
        if (clusterManager != null) {
            ServiceContext serviceContext;
            ServiceGroupContext sgContext;
            ContextManager contextManager = clusterManager.getContextManager();
            if (contextManager == null) {
                String msg = "Cannot replicate contexts since ContextManager is not specified in the axis2.xml file.";
                throw new ClusteringFault(msg);
            }
            ArrayList<AbstractContext> contexts = new ArrayList<AbstractContext>();
            if (!configurationContext.getPropertyDifferences().isEmpty()) {
                contexts.add(configurationContext);
            }
            if ((sgContext = msgContext.getServiceGroupContext()) != null && !sgContext.getPropertyDifferences().isEmpty()) {
                contexts.add(sgContext);
            }
            if ((serviceContext = msgContext.getServiceContext()) != null && !serviceContext.getPropertyDifferences().isEmpty()) {
                contexts.add(serviceContext);
            }
            if (!contexts.isEmpty()) {
                AbstractContext[] contextArray = contexts.toArray(new AbstractContext[contexts.size()]);
                String msgUUID = contextManager.updateContexts(contextArray);
                Replicator.waitForACKs(contextManager, msgUUID, msgContext.getRootContext());
            }
        } else {
            String msg = "Cannot replicate contexts since ClusterManager is not specified in the axis2.xml file.";
            throw new ClusteringFault(msg);
        }
    }

    private static void waitForACKs(ContextManager contextManager, String msgUUID, ConfigurationContext configCtx) throws ClusteringFault {
        long start = System.currentTimeMillis();
        do {
            try {
                Long tts = (Long)configCtx.getPropertyNonReplicable("local_cluster.time.to.send");
                if (tts == null) {
                    Thread.sleep(5L);
                } else if (tts >= 0L) {
                    Thread.sleep(tts + 5L);
                }
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= 45000L) continue;
            throw new ClusteringFault("ACKs not received from all members within 45 sec. Aborting wait.");
        } while (!contextManager.isMessageAcknowledged(msgUUID));
    }
}

