/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.context.AbstractContext;
import org.wso2.caching.CachedObject;

public class CacheManager
implements Serializable {
    private List cache = new ArrayList();

    public synchronized void resetCache(AbstractContext context) {
        this.removeCachedObjects(context);
        this.cache.clear();
    }

    public synchronized void removeExpiredResponses(AbstractContext context) {
        Iterator itr = this.cache.iterator();
        while (itr.hasNext()) {
            CachedObject cachedObj;
            String key = itr.next().toString();
            Object o = context.getProperty(key);
            if (o == null || !(o instanceof CachedObject) || !(cachedObj = (CachedObject)o).isExpired()) continue;
            this.cache.remove(key);
            context.removeProperty(key);
        }
    }

    public CachedObject getResponseForKey(String key, AbstractContext context) {
        if (this.cache.contains(key)) {
            Object obj = context.getProperty(key);
            return obj instanceof CachedObject ? (CachedObject)obj : null;
        }
        return null;
    }

    public void addResponseWithKey(String key, CachedObject response, AbstractContext context) {
        context.setProperty(key, (Object)response);
        this.cache.add(key);
    }

    public boolean containsKey(String key) {
        return this.cache.contains(key);
    }

    public List getCacheKeys() {
        return this.cache;
    }

    private synchronized void removeCachedObjects(AbstractContext context) {
        for (int i = 0; i < this.cache.size(); ++i) {
            context.removeProperty((String)this.cache.get(i));
        }
    }
}

