/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class MessageNumber
implements IOMRMElement {
    private long messageNumber;
    private String namespaceValue = null;

    public MessageNumber(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(long messageNumber) {
        this.messageNumber = messageNumber;
    }

    public Object fromOMElement(OMElement sequenceElement) throws OMException {
        OMElement msgNumberPart = sequenceElement.getFirstChildWithName(new QName(this.namespaceValue, "MessageNumber"));
        if (msgNumberPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noMessageNumberPartInElement", sequenceElement.toString()));
        }
        String msgNoStr = msgNumberPart.getText();
        this.messageNumber = Long.parseLong(msgNoStr);
        return this;
    }

    public OMElement toOMElement(OMElement element) throws OMException {
        if (this.messageNumber <= 0L) {
            throw new OMException(SandeshaMessageHelper.getMessage("setAValidMsgNumber", Long.toString(this.messageNumber)));
        }
        OMFactory factory = element.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement messageNoElement = factory.createOMElement("MessageNumber", rmNamespace);
        messageNoElement.setText(Long.toString(this.messageNumber));
        element.addChild((OMNode)messageNoElement);
        return element;
    }

    public String getNamespaceValue() throws OMException {
        return this.namespaceValue;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

