/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class AckFinal
implements IOMRMElement {
    private String namespaceValue = null;

    public AckFinal(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement element) throws OMException {
        OMElement finalPart = element.getFirstChildWithName(new QName(this.namespaceValue, "Final"));
        if (finalPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noFinalPartInElement", element.toString()));
        }
        return this;
    }

    public OMElement toOMElement(OMElement sequenceAckElement) throws OMException {
        OMFactory factory = sequenceAckElement.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement finalElement = factory.createOMElement("Final", rmNamespace);
        sequenceAckElement.addChild((OMNode)finalElement);
        return sequenceAckElement;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return false;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

