/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SandeshaWorker;
import org.apache.sandesha2.wsrm.Sequence;

public class InvokerWorker
extends SandeshaWorker
implements Runnable {
    ConfigurationContext configurationContext = null;
    String messageContextKey;
    boolean ignoreNextMsg = false;
    Log log = LogFactory.getLog((Class)InvokerWorker.class);

    public InvokerWorker(ConfigurationContext configurationContext, String messageContextKey, boolean ignoreNextMsg) {
        this.configurationContext = configurationContext;
        this.messageContextKey = messageContextKey;
        this.ignoreNextMsg = ignoreNextMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Enter: InvokerWorker::run");
        }
        Transaction transaction = null;
        MessageContext msgToInvoke = null;
        try {
            StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(this.configurationContext, (AxisDescription)this.configurationContext.getAxisConfiguration());
            InvokerBeanMgr invokerBeanMgr = storageManager.getInvokerBeanMgr();
            transaction = storageManager.getTransaction();
            InvokerBean invokerBean = invokerBeanMgr.retrieve(this.messageContextKey);
            msgToInvoke = storageManager.retrieveMessageContext(this.messageContextKey, this.configurationContext);
            if (transaction != null) {
                transaction.commit();
                transaction = storageManager.getTransaction();
            }
            RMMsgContext rmMsg = MsgInitializer.initializeMessage(msgToInvoke);
            SandeshaUtil.getRMDBeanFromSequenceId(storageManager, invokerBean.getSequenceID());
            invokerBeanMgr.delete(this.messageContextKey);
            storageManager.removeMessageContext(this.messageContextKey);
            try {
                boolean postFailureInvocation = false;
                String postFaulureProperty = (String)msgToInvoke.getProperty("PostFailureMessage");
                if (postFaulureProperty != null && "true".equals(postFaulureProperty)) {
                    postFailureInvocation = true;
                }
                if (postFailureInvocation) {
                    this.makeMessageReadyForReinjection(msgToInvoke);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Receiving message, key=" + this.messageContextKey + ", msgCtx=" + msgToInvoke.getEnvelope().getHeader()));
                    }
                    AxisEngine.receive((MessageContext)msgToInvoke);
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Resuming message, key=" + this.messageContextKey + ", msgCtx=" + msgToInvoke.getEnvelope().getHeader()));
                    }
                    msgToInvoke.setPaused(false);
                    AxisEngine.resumeReceive((MessageContext)msgToInvoke);
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Exception :", (Throwable)e);
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
                this.handleFault(rmMsg, e);
            }
            transaction = storageManager.getTransaction();
            if (rmMsg.getMessageType() == 3) {
                Sequence sequence = (Sequence)rmMsg.getMessagePart(6);
                boolean highestMessage = false;
                if (sequence.getLastMessage() != null) {
                    highestMessage = true;
                } else {
                    RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, invokerBean.getSequenceID());
                    if (rmdBean != null && rmdBean.isTerminated()) {
                        long highestInMsgNo = rmdBean.getHighestInMessageNumber();
                        if (invokerBean.getMsgNo() == highestInMsgNo) {
                            highestMessage = true;
                        }
                    }
                }
                if (highestMessage) {
                    TerminateManager.cleanReceivingSideAfterInvocation(invokerBean.getSequenceID(), storageManager);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Exit: InvokerWorker::run Last message return");
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    return;
                }
            }
            if (!this.ignoreNextMsg) {
                RMDBean rMDBean = storageManager.getRMDBeanMgr().retrieve(invokerBean.getSequenceID());
                long nextMsgNo = rMDBean.getNextMsgNoToProcess();
                if (invokerBean.getMsgNo() != nextMsgNo) {
                    String message = "Operated message number is different from the Next Message Number to invoke";
                    throw new SandeshaException(message);
                }
                rMDBean.setNextMsgNoToProcess(++nextMsgNo);
                storageManager.getRMDBeanMgr().update(rMDBean);
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
        }
        finally {
            block42: {
                if (this.workId != null && this.lock != null) {
                    this.lock.removeWork(this.workId);
                }
                if (transaction != null && transaction.isActive()) {
                    try {
                        transaction.rollback();
                    }
                    catch (SandeshaStorageException e) {
                        if (!this.log.isWarnEnabled()) break block42;
                        this.log.warn((Object)"Caught exception rolling back transaction", (Throwable)((Object)e));
                    }
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Exit: InvokerWorker::run");
        }
    }

    private void makeMessageReadyForReinjection(MessageContext messageContext) {
        messageContext.setProperty("WSAddressingVersion", null);
        messageContext.getOptions().setMessageId(null);
        messageContext.getOptions().setTo(null);
        messageContext.getOptions().setAction(null);
        messageContext.setProperty("Sandesha2AppProcessingDone", (Object)"true");
    }

    private void handleFault(RMMsgContext inRMMsgContext, Exception e) {
        block7: {
            MessageContext inMsgContext = inRMMsgContext.getMessageContext();
            try {
                MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)inMsgContext, (Throwable)e);
                faultContext.setProperty("ContentType", inMsgContext.getProperty("ContentType"));
                EndpointReference faultEPR = inRMMsgContext.getFaultTo();
                if (faultEPR == null) {
                    faultEPR = inRMMsgContext.getReplyTo();
                }
                if ("Spec_2005_02".equals(inRMMsgContext.getRMSpecVersion()) && (faultEPR == null || faultEPR.hasAnonymousAddress())) {
                    RequestResponseTransport requestResponseTransport = (RequestResponseTransport)inRMMsgContext.getProperty("RequestResponseTransportControl");
                    AxisFault fault = new AxisFault("Sandesha2 got a fault when doing the invocation", faultContext);
                    if (requestResponseTransport != null) {
                        requestResponseTransport.signalFaultReady(fault);
                    } else {
                        this.sendFaultIfPossible(faultContext);
                    }
                } else {
                    this.sendFaultIfPossible(faultContext);
                }
            }
            catch (AxisFault e1) {
                if (!this.log.isErrorEnabled()) break block7;
                this.log.error((Object)"Unable to send fault message ", (Throwable)e1);
            }
        }
    }

    private void sendFaultIfPossible(MessageContext faultContext) throws AxisFault {
        EndpointReference epr = null;
        String transportURL = (String)faultContext.getProperty("TransportURL");
        if (transportURL != null) {
            epr = new EndpointReference(transportURL);
        } else if (faultContext.getTo() != null && !faultContext.getTo().hasAnonymousAddress()) {
            epr = faultContext.getTo();
        }
        Object transportOut = faultContext.getProperty("TRANSPORT_OUT");
        if (epr == null && transportOut == null) {
            this.log.warn((Object)"Both the TO and MessageContext.TRANSPORT_OUT property are null, so nowhere to send the fault");
        } else {
            AxisEngine.sendFault((MessageContext)faultContext);
        }
    }
}

