/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SandeshaListener;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SequenceEntry;
import org.apache.sandesha2.wsrm.CreateSequence;

public class SequenceManager {
    private static Log log = LogFactory.getLog((Class)SequenceManager.class);

    public static RMDBean setupNewSequence(RMMsgContext createSequenceMsg, StorageManager storageManager, SecurityManager securityManager, SecurityToken token) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SequenceManager::setupNewSequence");
        }
        String sequenceId = SandeshaUtil.getUUID();
        RMDBean rmdBean = new RMDBean();
        EndpointReference to = createSequenceMsg.getTo();
        if (to == null) {
            String message = SandeshaMessageHelper.getMessage("toEPRNotValid", null);
            log.debug((Object)message);
            throw new AxisFault(message);
        }
        EndpointReference replyTo = createSequenceMsg.getReplyTo();
        CreateSequence createSequence = (CreateSequence)createSequenceMsg.getMessagePart(9);
        if (createSequence == null) {
            String message = SandeshaMessageHelper.getMessage("createSeqEntryNotFound");
            log.debug((Object)message);
            throw new AxisFault(message);
        }
        EndpointReference acksTo = createSequence.getAcksTo().getEPR();
        if (acksTo == null) {
            FaultManager.makeCreateSequenceRefusedFault(createSequenceMsg, SandeshaMessageHelper.getMessage("noAcksToPartInCreateSequence"), new Exception());
        } else if (acksTo.getAddress().equals("http://www.w3.org/2005/08/addressing/none")) {
            FaultManager.makeCreateSequenceRefusedFault(createSequenceMsg, "AcksTo can not be http://www.w3.org/2005/08/addressing/none", new Exception());
        }
        MessageContext createSeqContext = createSequenceMsg.getMessageContext();
        SequenceEntry entry = (SequenceEntry)createSeqContext.getProperty("Sandesha2MakeConnectionEntry");
        if (log.isDebugEnabled()) {
            log.debug((Object)("This message is associated with sequence entry: " + entry));
        }
        if (entry != null && entry.isRmSource()) {
            rmdBean.setOutboundInternalSequence(entry.getSequenceId());
        }
        rmdBean.setServerCompletedMessages(new RangeString());
        rmdBean.setReplyToEPR(to.getAddress());
        rmdBean.setAcksToEPR(acksTo.getAddress());
        if (replyTo != null) {
            rmdBean.setToEPR(replyTo.getAddress());
        }
        if (token != null) {
            String tokenData = securityManager.getTokenRecoveryData(token);
            rmdBean.setSecurityTokenData(tokenData);
        }
        rmdBean.setSequenceID(sequenceId);
        rmdBean.setNextMsgNoToProcess(1L);
        rmdBean.setToAddress(to.getAddress());
        if (to.hasAnonymousAddress()) {
            String newKey = SandeshaUtil.getUUID();
            rmdBean.setPollingMode(true);
            rmdBean.setReferenceMessageKey(newKey);
            storageManager.storeMessageContext(newKey, createSeqContext);
        }
        String messageRMNamespace = createSequence.getNamespaceValue();
        String specVersion = null;
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(messageRMNamespace)) {
            specVersion = "Spec_2005_02";
        } else if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(messageRMNamespace)) {
            specVersion = "Spec_2007_02";
        } else {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotDecideRMVersion"));
        }
        rmdBean.setRMVersion(specVersion);
        rmdBean.setLastActivatedTime(System.currentTimeMillis());
        storageManager.getRMDBeanMgr().insert(rmdBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SequenceManager::setupNewSequence, " + rmdBean));
        }
        return rmdBean;
    }

    public void removeSequence(String sequence) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static RMSBean setupNewClientSequence(MessageContext firstAplicationMsgCtx, String internalSequenceId, StorageManager storageManager) throws SandeshaException {
        Object avoidAutoTermination;
        EndpointReference replyToEPR;
        EndpointReference acksToEPR;
        String specVersion;
        RMSBean rmsBean;
        block19: {
            String acksTo;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Enter: SequenceManager::setupNewClientSequence");
            }
            rmsBean = new RMSBean();
            rmsBean.setInternalSequenceID(internalSequenceId);
            String inboundSequence = null;
            RMDBean inboundBean = null;
            if (firstAplicationMsgCtx.isServerSide() && (inboundSequence = (String)firstAplicationMsgCtx.getProperty("Sandesha2InboundSequenceId")) != null) {
                inboundBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequence);
            }
            specVersion = SequenceManager.getSpecVersion(firstAplicationMsgCtx, storageManager);
            rmsBean.setRMVersion(specVersion);
            EndpointReference toEPR = firstAplicationMsgCtx.getTo();
            if (toEPR == null) {
                String message = SandeshaMessageHelper.getMessage("toEPRNotValid", null);
                log.debug((Object)message);
                throw new SandeshaException(message);
            }
            rmsBean.setToEPR(toEPR.getAddress());
            acksToEPR = null;
            replyToEPR = null;
            if (firstAplicationMsgCtx.isServerSide()) {
                if (inboundBean != null && inboundBean.getReplyToEPR() != null) {
                    acksToEPR = new EndpointReference(inboundBean.getReplyToEPR());
                    replyToEPR = new EndpointReference(inboundBean.getReplyToEPR());
                    break block19;
                } else {
                    String beanInfo = inboundBean == null ? "null" : inboundBean.toString();
                    String message = SandeshaMessageHelper.getMessage("cannotChooseAcksTo", inboundSequence, beanInfo);
                    SandeshaException e = new SandeshaException(message);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Throwing", (Throwable)((Object)e));
                    }
                    throw e;
                }
            }
            replyToEPR = firstAplicationMsgCtx.getReplyTo();
            if (replyToEPR != null && replyToEPR.hasNoneAddress()) {
                replyToEPR = null;
            }
            if ((acksTo = (String)firstAplicationMsgCtx.getProperty(SandeshaClientConstants.AcksTo)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using explicit AcksTo, addr=" + acksTo));
                }
                acksToEPR = new EndpointReference(acksTo);
            } else if (replyToEPR != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using replyTo EPR as AcksTo, addr=" + replyToEPR.getAddress()));
                }
                acksToEPR = replyToEPR;
            }
        }
        ConfigurationContext config = firstAplicationMsgCtx.getConfigurationContext();
        if ("Spec_2007_02".equals(specVersion)) {
            replyToEPR = SandeshaUtil.rewriteEPR(rmsBean, replyToEPR, config);
            acksToEPR = SandeshaUtil.rewriteEPR(rmsBean, acksToEPR, config);
        }
        if (replyToEPR != null) {
            rmsBean.setReplyToEPR(replyToEPR.getAddress());
        }
        if (acksToEPR != null) {
            rmsBean.setAcksToEPR(acksToEPR.getAddress());
        }
        rmsBean.setClientCompletedMessages(new RangeString());
        String transportTo = (String)firstAplicationMsgCtx.getProperty("TransportURL");
        if (transportTo != null) {
            rmsBean.setTransportTo(transportTo);
        }
        rmsBean.setSoapVersion(SandeshaUtil.getSOAPVersion(firstAplicationMsgCtx.getEnvelope()));
        if (!firstAplicationMsgCtx.isServerSide() && (avoidAutoTermination = firstAplicationMsgCtx.getProperty(SandeshaClientConstants.AVOID_AUTO_TERMINATION)) != null && JavaUtils.isTrueExplicitly((Object)avoidAutoTermination)) {
            rmsBean.setAvoidAutoTermination(true);
        }
        rmsBean.setLastActivatedTime(System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SequenceManager::setupNewClientSequence " + rmsBean));
        }
        return rmsBean;
    }

    public static boolean hasSequenceTimedOut(RMSBean rmsBean, String internalSequenceId, StorageManager storageManager) throws SandeshaException {
        SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean((AxisDescription)storageManager.getContext().getAxisConfiguration());
        if (propertyBean.getInactivityTimeoutInterval() <= 0L) {
            return false;
        }
        boolean sequenceTimedOut = false;
        long lastActivatedTime = rmsBean.getLastActivatedTime();
        long timeNow = System.currentTimeMillis();
        if (lastActivatedTime > 0L && lastActivatedTime + propertyBean.getInactivityTimeoutInterval() < timeNow) {
            sequenceTimedOut = true;
        }
        return sequenceTimedOut;
    }

    public static void finalizeTimedOutSequence(String internalSequenceID, MessageContext messageContext, StorageManager storageManager) throws SandeshaException {
        SandeshaListener listener;
        ConfigurationContext configurationContext = null;
        configurationContext = messageContext == null ? storageManager.getContext() : messageContext.getConfigurationContext();
        AxisFault fault = new AxisFault(SandeshaMessageHelper.getMessage("cannotSendMsgAsSequenceTimedout", internalSequenceID));
        FaultManager.notifyClientsOfFault(internalSequenceID, storageManager, configurationContext, fault);
        TerminateManager.timeOutSendingSideSequence(internalSequenceID, storageManager);
        if (messageContext != null && (listener = (SandeshaListener)messageContext.getProperty(SandeshaClientConstants.SANDESHA_LISTENER)) != null) {
            SequenceReport report = SandeshaClient.getOutgoingSequenceReport(internalSequenceID, configurationContext, false);
            listener.onTimeOut(report);
        }
    }

    public static String getSpecVersion(MessageContext applicationMessage, StorageManager storageManager) throws SandeshaException {
        String specVersion = null;
        if (applicationMessage.isServerSide()) {
            String inboundSequence = null;
            RMSequenceBean inboundBean = null;
            if (applicationMessage.isServerSide() && (inboundSequence = (String)applicationMessage.getProperty("Sandesha2InboundSequenceId")) != null) {
                inboundBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequence);
            }
            if (inboundBean == null || inboundBean.getRMVersion() == null) {
                String beanInfo = inboundBean == null ? "null" : ((RMDBean)inboundBean).toString();
                String message = SandeshaMessageHelper.getMessage("cannotChooseSpecLevel", inboundSequence, beanInfo);
                SandeshaException e = new SandeshaException(message);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Throwing", (Throwable)((Object)e));
                }
                throw e;
            }
            specVersion = inboundBean.getRMVersion();
        } else {
            specVersion = (String)applicationMessage.getProperty(SandeshaClientConstants.RM_SPEC_VERSION);
            Parameter opLevel = applicationMessage.getAxisOperation().getParameter(SandeshaClientConstants.RM_SPEC_VERSION);
            if (specVersion == null && opLevel != null) {
                specVersion = (String)opLevel.getValue();
            }
        }
        if (specVersion == null) {
            specVersion = SpecSpecificConstants.getDefaultSpecVersion();
        }
        return specVersion;
    }
}

