/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.Accept;
import org.apache.sandesha2.wsrm.AckFinal;
import org.apache.sandesha2.wsrm.AcksTo;
import org.apache.sandesha2.wsrm.Address;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.CloseSequenceResponse;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;
import org.apache.sandesha2.wsrm.Endpoint;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.MakeConnection;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.SequenceOffer;
import org.apache.sandesha2.wsrm.TerminateSequence;
import org.apache.sandesha2.wsrm.TerminateSequenceResponse;
import org.apache.sandesha2.wsrm.UsesSequenceSTR;

public class RMMsgCreator {
    private static Log log = LogFactory.getLog((Class)RMMsgCreator.class);

    public static RMMsgContext createCreateSeqMsg(RMSBean rmsBean, RMMsgContext applicationRMMsg) throws AxisFault {
        Parameter p;
        MessageContext applicationMsgContext = applicationRMMsg.getMessageContext();
        if (applicationMsgContext == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("appMsgIsNull"));
        }
        ConfigurationContext context = applicationMsgContext.getConfigurationContext();
        if (context == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("configContextNotSet"));
        }
        AxisOperation createSequenceOperation = SpecSpecificConstants.getWSRMOperation(1, rmsBean.getRMVersion(), applicationMsgContext.getAxisService());
        MessageContext createSeqmsgContext = SandeshaUtil.createNewRelatedMessageContext(applicationRMMsg, createSequenceOperation);
        OperationContext createSeqOpCtx = createSeqmsgContext.getOperationContext();
        String createSeqMsgId = SandeshaUtil.getUUID();
        createSeqmsgContext.setMessageID(createSeqMsgId);
        context.registerOperationContext(createSeqMsgId, createSeqOpCtx);
        RMMsgContext createSeqRMMsg = new RMMsgContext(createSeqmsgContext);
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmsBean.getRMVersion());
        String addressingNamespace = (String)applicationMsgContext.getProperty("WSAddressingVersion");
        Boolean disableAddressing = (Boolean)applicationMsgContext.getProperty("disableAddressingForOutMessages");
        if (addressingNamespace == null) {
            addressingNamespace = disableAddressing != null && disableAddressing != false ? SpecSpecificConstants.getAddressingNamespace(rmNamespaceValue) : "http://www.w3.org/2005/08/addressing";
        }
        EndpointReference acksToEPR = null;
        String acksToAddress = rmsBean.getAcksToEPR();
        acksToEPR = acksToAddress != null ? new EndpointReference(acksToAddress) : new EndpointReference(SpecSpecificConstants.getAddressingAnonymousURI(addressingNamespace));
        CreateSequence createSequencePart = new CreateSequence(rmNamespaceValue);
        boolean twoWayService = false;
        AxisService service = applicationMsgContext.getAxisService();
        if (service != null && (p = service.getParameter("ServiceContainsOutInMeps")) != null && p.getValue() != null) {
            twoWayService = (Boolean)p.getValue();
        }
        boolean autoOffer = false;
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(rmNamespaceValue)) {
            autoOffer = twoWayService;
        } else {
            SandeshaPolicyBean policy = SandeshaUtil.getPropertyBean((AxisDescription)context.getAxisConfiguration());
            if (twoWayService && !policy.isEnableMakeConnection()) {
                String message = SandeshaMessageHelper.getMessage("makeConnectionWarning");
                log.warn((Object)message);
            }
        }
        String offeredSequenceId = (String)applicationMsgContext.getProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID);
        if (autoOffer || offeredSequenceId != null && offeredSequenceId.length() > 0) {
            if (offeredSequenceId == null || offeredSequenceId.length() == 0) {
                offeredSequenceId = SandeshaUtil.getUUID();
            }
            SequenceOffer offerPart = new SequenceOffer(rmNamespaceValue);
            Identifier identifier = new Identifier(rmNamespaceValue);
            identifier.setIndentifer(offeredSequenceId);
            offerPart.setIdentifier(identifier);
            createSequencePart.setSequenceOffer(offerPart);
            if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(rmNamespaceValue)) {
                EndpointReference replyTo;
                EndpointReference offeredEndpoint = (EndpointReference)applicationMsgContext.getProperty(SandeshaClientConstants.OFFERED_ENDPOINT);
                if (offeredEndpoint == null && (replyTo = applicationMsgContext.getReplyTo()) != null) {
                    offeredEndpoint = SandeshaUtil.cloneEPR(replyTo);
                }
                if (offeredEndpoint == null) {
                    offeredEndpoint = new EndpointReference(SpecSpecificConstants.getAddressingAnonymousURI(addressingNamespace));
                }
                Endpoint endpoint = new Endpoint(offeredEndpoint, rmNamespaceValue, addressingNamespace);
                offerPart.setEndpoint(endpoint);
            }
        }
        String to = rmsBean.getToEPR();
        String replyTo = rmsBean.getReplyToEPR();
        if (to == null) {
            String message = SandeshaMessageHelper.getMessage("toBeanNotSet");
            throw new SandeshaException(message);
        }
        EndpointReference toEPR = new EndpointReference(to);
        createSeqRMMsg.setTo(toEPR);
        if (replyTo != null) {
            EndpointReference replyToEPR = new EndpointReference(replyTo);
            createSeqRMMsg.setReplyTo(replyToEPR);
        }
        AcksTo acksTo = new AcksTo(acksToEPR, rmNamespaceValue, addressingNamespace);
        createSequencePart.setAcksTo(acksTo);
        createSeqRMMsg.setMessagePart(9, createSequencePart);
        SecurityManager secMgr = SandeshaUtil.getSecurityManager(context);
        SecurityToken token = secMgr.getSecurityToken(applicationMsgContext);
        if (token != null) {
            OMElement str = secMgr.createSecurityTokenReference(token, createSeqmsgContext);
            createSequencePart.setSecurityTokenReference(str);
            createSeqRMMsg.setProperty("SecurityToken", token);
            if (createSequencePart.getNamespaceValue().equals("http://docs.oasis-open.org/ws-rx/wsrm/200702")) {
                UsesSequenceSTR header = new UsesSequenceSTR(null, "http://docs.oasis-open.org/ws-rx/wsrm/200702");
                header.toSOAPEnvelope(createSeqmsgContext.getEnvelope());
            }
            secMgr.applySecurityToken(token, createSeqRMMsg.getMessageContext());
        }
        createSeqRMMsg.setAction(SpecSpecificConstants.getCreateSequenceAction(rmsBean.getRMVersion()));
        createSeqRMMsg.setSOAPAction(SpecSpecificConstants.getCreateSequenceSOAPAction(rmsBean.getRMVersion()));
        createSeqRMMsg.addSOAPEnvelope();
        return createSeqRMMsg;
    }

    public static RMMsgContext createTerminateSequenceMessage(RMMsgContext referenceRMMessage, RMSBean rmsBean, StorageManager storageManager) throws AxisFault {
        MessageContext referenceMessage = referenceRMMessage.getMessageContext();
        if (referenceMessage == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("msgContextNotSet"));
        }
        AxisOperation terminateOperation = SpecSpecificConstants.getWSRMOperation(7, rmsBean.getRMVersion(), referenceMessage.getAxisService());
        ConfigurationContext configCtx = referenceMessage.getConfigurationContext();
        if (configCtx == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("configContextNotSet"));
        }
        MessageContext terminateMessage = SandeshaUtil.createNewRelatedMessageContext(referenceRMMessage, terminateOperation);
        if (terminateMessage.getMessageID() == null) {
            terminateMessage.setMessageID(SandeshaUtil.getUUID());
        }
        OperationContext operationContext = terminateMessage.getOperationContext();
        configCtx.registerOperationContext(terminateMessage.getMessageID(), operationContext);
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmsBean.getRMVersion());
        RMMsgContext terminateRMMessage = MsgInitializer.initializeMessage(terminateMessage);
        if (terminateMessage == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("msgContextNotSet"));
        }
        TerminateSequence terminateSequencePart = new TerminateSequence(rmNamespaceValue);
        Identifier identifier = new Identifier(rmNamespaceValue);
        identifier.setIndentifer(rmsBean.getSequenceID());
        terminateSequencePart.setIdentifier(identifier);
        terminateRMMessage.setMessagePart(11, terminateSequencePart);
        terminateMessage.setProperty("TRANSPORT_IN", null);
        terminateMessage.setTo(new EndpointReference(rmsBean.getToEPR()));
        RMMsgCreator.secureOutboundMessage(rmsBean, terminateMessage);
        return terminateRMMessage;
    }

    public static RMMsgContext createCreateSeqResponseMsg(RMMsgContext createSeqMessage, RMSequenceBean rmSequenceBean) throws AxisFault {
        String outSequenceId;
        CreateSequence cs = (CreateSequence)createSeqMessage.getMessagePart(9);
        String namespace = createSeqMessage.getRMNamespaceValue();
        CreateSequenceResponse response = new CreateSequenceResponse(namespace);
        Identifier identifier = new Identifier(namespace);
        identifier.setIndentifer(rmSequenceBean.getSequenceID());
        response.setIdentifier(identifier);
        SequenceOffer offer = cs.getSequenceOffer();
        if (offer != null && (outSequenceId = offer.getIdentifer().getIdentifier()) != null && !"".equals(outSequenceId)) {
            Accept accept = new Accept(namespace);
            String addressingNamespace = cs.getAddressingNamespaceValue();
            EndpointReference acksToEPR = createSeqMessage.getTo();
            if (acksToEPR != null) {
                acksToEPR = SandeshaUtil.cloneEPR(acksToEPR);
            } else {
                String anon = SpecSpecificConstants.getAddressingAnonymousURI(addressingNamespace);
                acksToEPR = new EndpointReference(anon);
            }
            AcksTo acksTo = new AcksTo(acksToEPR, namespace, cs.getAddressingNamespaceValue());
            accept.setAcksTo(acksTo);
            response.setAccept(accept);
        }
        String version = SpecSpecificConstants.getSpecVersionString(namespace);
        String action = SpecSpecificConstants.getCreateSequenceResponseAction(version);
        return RMMsgCreator.createResponseMsg(createSeqMessage, rmSequenceBean, response, 10, action);
    }

    public static RMMsgContext createTerminateSeqResponseMsg(RMMsgContext terminateSeqRMMsg, RMSequenceBean rmSequenceBean) throws AxisFault {
        TerminateSequence terminateSequence = (TerminateSequence)terminateSeqRMMsg.getMessagePart(11);
        String sequenceID = terminateSequence.getIdentifier().getIdentifier();
        String namespace = terminateSeqRMMsg.getRMNamespaceValue();
        TerminateSequenceResponse terminateSequenceResponse = new TerminateSequenceResponse(namespace);
        Identifier identifier = new Identifier(namespace);
        identifier.setIndentifer(sequenceID);
        terminateSequenceResponse.setIdentifier(identifier);
        String version = SpecSpecificConstants.getSpecVersionString(namespace);
        String action = SpecSpecificConstants.getTerminateSequenceResponseAction(version);
        return RMMsgCreator.createResponseMsg(terminateSeqRMMsg, rmSequenceBean, terminateSequenceResponse, 14, action);
    }

    public static RMMsgContext createCloseSeqResponseMsg(RMMsgContext closeSeqRMMsg, RMSequenceBean rmSequenceBean) throws AxisFault {
        CloseSequence closeSequence = (CloseSequence)closeSeqRMMsg.getMessagePart(12);
        String sequenceID = closeSequence.getIdentifier().getIdentifier();
        String namespace = closeSeqRMMsg.getRMNamespaceValue();
        CloseSequenceResponse closeSequenceResponse = new CloseSequenceResponse(namespace);
        Identifier identifier = new Identifier(namespace);
        identifier.setIndentifer(sequenceID);
        closeSequenceResponse.setIdentifier(identifier);
        String version = SpecSpecificConstants.getSpecVersionString(namespace);
        String action = SpecSpecificConstants.getCloseSequenceResponseAction(version);
        return RMMsgCreator.createResponseMsg(closeSeqRMMsg, rmSequenceBean, closeSequenceResponse, 13, action);
    }

    private static RMMsgContext createResponseMsg(RMMsgContext requestMsg, RMSequenceBean rmSequenceBean, IOMRMPart part, int messagePartId, String action) throws AxisFault {
        MessageContext outMessage = MessageContextBuilder.createOutMessageContext((MessageContext)requestMsg.getMessageContext());
        RMMsgContext responseRMMsg = new RMMsgContext(outMessage);
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(requestMsg.getSOAPEnvelope()));
        String namespace = requestMsg.getRMNamespaceValue();
        responseRMMsg.setRMNamespaceValue(namespace);
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        responseRMMsg.setSOAPEnvelop(envelope);
        responseRMMsg.setMessagePart(messagePartId, part);
        outMessage.setWSAAction(action);
        outMessage.setSoapAction(action);
        responseRMMsg.addSOAPEnvelope();
        responseRMMsg.getMessageContext().setServerSide(true);
        RMMsgCreator.secureOutboundMessage(rmSequenceBean, outMessage);
        return responseRMMsg;
    }

    public static void addAckMessage(RMMsgContext applicationMsg, String sequenceId, RMDBean rmdBean) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entry: RMMsgCreator::addAckMessage " + sequenceId));
        }
        String rmVersion = rmdBean.getRMVersion();
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmVersion);
        SequenceAcknowledgement sequenceAck = new SequenceAcknowledgement(rmNamespaceValue);
        Identifier id = new Identifier(rmNamespaceValue);
        id.setIndentifer(sequenceId);
        sequenceAck.setIdentifier(id);
        ArrayList ackRangeArrayList = SandeshaUtil.getAckRangeArrayList(rmdBean.getServerCompletedMessages(), rmNamespaceValue);
        sequenceAck.setAckRanges(ackRangeArrayList);
        if (rmdBean.isClosed() && SpecSpecificConstants.isAckFinalAllowed(rmVersion)) {
            AckFinal ackFinal = new AckFinal(rmNamespaceValue);
            sequenceAck.setAckFinal(ackFinal);
        }
        applicationMsg.setMessagePart(7, sequenceAck);
        if (applicationMsg.getWSAAction() == null) {
            applicationMsg.setAction(SpecSpecificConstants.getSequenceAcknowledgementAction(rmVersion));
            applicationMsg.setSOAPAction(SpecSpecificConstants.getSequenceAcknowledgementSOAPAction(rmVersion));
        }
        if (applicationMsg.getMessageId() == null) {
            applicationMsg.setMessageId(SandeshaUtil.getUUID());
        }
        try {
            applicationMsg.addSOAPEnvelope();
        }
        catch (AxisFault e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Caught AxisFault", (Throwable)e);
            }
            throw new SandeshaException(e.getMessage(), (Exception)((Object)e));
        }
        RMMsgCreator.secureOutboundMessage(rmdBean, applicationMsg.getMessageContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: RMMsgCreator::addAckMessage");
        }
    }

    public static RMMsgContext createMakeConnectionMessage(RMMsgContext referenceRMMessage, RMSequenceBean bean, String makeConnectionSeqId, String makeConnectionAnonURI, StorageManager storageManager) throws AxisFault {
        EndpointReference epr;
        MessageContext referenceMessage = referenceRMMessage.getMessageContext();
        String rmNamespaceValue = referenceRMMessage.getRMNamespaceValue();
        String rmVersion = referenceRMMessage.getRMSpecVersion();
        AxisOperation makeConnectionOperation = SpecSpecificConstants.getWSRMOperation(11, rmVersion, referenceMessage.getAxisService());
        MessageContext makeConnectionMessageCtx = SandeshaUtil.createNewRelatedMessageContext(referenceRMMessage, makeConnectionOperation);
        RMMsgContext makeConnectionRMMessageCtx = MsgInitializer.initializeMessage(makeConnectionMessageCtx);
        MakeConnection makeConnection = new MakeConnection("http://docs.oasis-open.org/ws-rx/wsmc/200702");
        if (makeConnectionSeqId != null) {
            Identifier identifier = new Identifier(rmNamespaceValue);
            identifier.setIndentifer(makeConnectionSeqId);
            makeConnection.setIdentifier(identifier);
        }
        if (makeConnectionAnonURI != null) {
            Address address = new Address("http://docs.oasis-open.org/ws-rx/wsmc/200702");
            address.setAddress(makeConnectionAnonURI);
            makeConnection.setAddress(address);
        }
        if ((epr = referenceMessage.getTo()).hasAnonymousAddress()) {
            epr = referenceMessage.getReplyTo();
        }
        makeConnectionMessageCtx.setTo(epr);
        makeConnectionMessageCtx.setWSAAction(SpecSpecificConstants.getMakeConnectionAction(rmVersion));
        makeConnectionMessageCtx.setMessageID(SandeshaUtil.getUUID());
        makeConnectionRMMessageCtx.setMessagePart(17, makeConnection);
        makeConnectionRMMessageCtx.addSOAPEnvelope();
        RMMsgCreator.secureOutboundMessage(bean, makeConnectionMessageCtx);
        return makeConnectionRMMessageCtx;
    }

    public static void secureOutboundMessage(RMSequenceBean rmBean, MessageContext message) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entry: RMMsgCreator::secureOutboundMessage");
        }
        ConfigurationContext configCtx = message.getConfigurationContext();
        if (rmBean.getSecurityTokenData() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Securing outbound message");
            }
            SecurityManager secManager = SandeshaUtil.getSecurityManager(configCtx);
            SecurityToken token = secManager.recoverSecurityToken(rmBean.getSecurityTokenData());
            secManager.applySecurityToken(token, message);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: RMMsgCreator::secureOutboundMessage");
        }
    }
}

