/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SequenceManager;

public class MessageRetransmissionAdjuster {
    private static final Log log = LogFactory.getLog((Class)MessageRetransmissionAdjuster.class);

    public static boolean adjustRetransmittion(RMMsgContext rmMsgCtx, SenderBean retransmitterBean, ConfigurationContext configContext, StorageManager storageManager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: MessageRetransmissionAdjuster::adjustRetransmittion");
        }
        String internalSequenceID = retransmitterBean.getInternalSequenceID();
        String sequenceID = retransmitterBean.getSequenceID();
        rmMsgCtx.setProperty("Sandesha2InternalSequenceId", internalSequenceID);
        rmMsgCtx.setProperty("WSRMSequenceId", sequenceID);
        SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean((AxisDescription)rmMsgCtx.getMessageContext().getAxisOperation());
        retransmitterBean.setSentCount(retransmitterBean.getSentCount() + 1);
        MessageRetransmissionAdjuster.adjustNextRetransmissionTime(retransmitterBean, propertyBean);
        int maxRetransmissionAttempts = propertyBean.getMaximumRetransmissionCount();
        boolean continueSending = true;
        if (internalSequenceID != null) {
            boolean timeOutSequence = false;
            if (maxRetransmissionAttempts >= 0 && retransmitterBean.getSentCount() > maxRetransmissionAttempts) {
                timeOutSequence = true;
            }
            if (timeOutSequence) {
                retransmitterBean.setSend(false);
                SequenceManager.finalizeTimedOutSequence(internalSequenceID, rmMsgCtx.getMessageContext(), storageManager);
                continueSending = false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: MessageRetransmissionAdjuster::adjustRetransmittion, " + continueSending));
        }
        return continueSending;
    }

    private static SenderBean adjustNextRetransmissionTime(SenderBean retransmitterBean, SandeshaPolicyBean propertyBean) throws SandeshaException {
        long baseInterval;
        int count = retransmitterBean.getSentCount();
        long newInterval = baseInterval = propertyBean.getRetransmissionInterval();
        if (propertyBean.isExponentialBackoff()) {
            newInterval = MessageRetransmissionAdjuster.generateNextExponentialBackedoffDifference(count, baseInterval);
        }
        long newTimeToSend = 0L;
        long timeNow = System.currentTimeMillis();
        newTimeToSend = timeNow + newInterval;
        retransmitterBean.setTimeToSend(newTimeToSend);
        return retransmitterBean;
    }

    private static long generateNextExponentialBackedoffDifference(int count, long initialInterval) {
        long interval = initialInterval;
        for (int i = 1; i < count; ++i) {
            interval *= 2L;
        }
        return interval;
    }
}

