/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;

public class AcknowledgementManager {
    private static Log log = LogFactory.getLog((Class)AcknowledgementManager.class);

    public static Transaction piggybackAcksIfPresent(RMMsgContext rmMessageContext, StorageManager storageManager, Transaction transaction) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementManager::piggybackAcksIfPresent");
        }
        SenderBeanMgr retransmitterBeanMgr = storageManager.getSenderBeanMgr();
        EndpointReference target = rmMessageContext.getTo();
        if (target == null || target.hasAnonymousAddress()) {
            if (target != null && SandeshaUtil.isWSRMAnonymous(target.getAddress())) {
                RMDBean findBean = new RMDBean();
                findBean.setAcksToEPR(target.getAddress());
                findBean.setTerminated(false);
                List rmdBeans = storageManager.getRMDBeanMgr().find(findBean);
                Iterator sequences = rmdBeans.iterator();
                while (sequences.hasNext()) {
                    RMDBean sequence = (RMDBean)sequences.next();
                    if (sequence.getHighestInMessageNumber() <= 0L) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Piggybacking ack for sequence: " + sequence.getSequenceID()));
                    }
                    RMMsgCreator.addAckMessage(rmMessageContext, sequence.getSequenceID(), sequence);
                }
            } else {
                RMDBean inboundBean;
                String inboundSequence = (String)rmMessageContext.getProperty("Sandesha2InboundSequenceId");
                if (inboundSequence != null && (inboundBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequence)) != null && !inboundBean.isTerminated()) {
                    String acksTo = inboundBean.getAcksToEPR();
                    EndpointReference acksToEPR = new EndpointReference(acksTo);
                    if (acksTo == null || acksToEPR.hasAnonymousAddress()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Piggybacking ack for inbound sequence: " + inboundSequence));
                        }
                        RMMsgCreator.addAckMessage(rmMessageContext, inboundSequence, inboundBean);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AcknowledgementManager::piggybackAcksIfPresent, anon");
            }
            return transaction;
        }
        HashSet<String> acked = new HashSet<String>();
        SenderBean findBean = new SenderBean();
        findBean.setMessageType(4);
        findBean.setSend(true);
        findBean.setToAddress(target.getAddress());
        List collection = retransmitterBeanMgr.find(findBean);
        if (transaction != null && transaction.isActive()) {
            transaction.commit();
        }
        transaction = storageManager.getTransaction();
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            RMDBean rmdBean;
            SenderBean ackBean = (SenderBean)it.next();
            long timeNow = System.currentTimeMillis();
            if (ackBean.getTimeToSend() <= timeNow) continue;
            retransmitterBeanMgr.delete(ackBean.getMessageID());
            storageManager.removeMessageContext(ackBean.getMessageContextRefKey());
            String sequenceId = ackBean.getSequenceID();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Piggybacking ack for sequence: " + sequenceId));
            }
            if ((rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceId)) != null && !rmdBean.isTerminated()) {
                RMMsgCreator.addAckMessage(rmMessageContext, sequenceId, rmdBean);
            }
            acked.add(sequenceId);
        }
        if (rmMessageContext.getMessageType() == 7) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding extra acks, as this is a terminate");
            }
            RMDBean findRMDBean = new RMDBean();
            findRMDBean.setAcksToEPR(target.getAddress());
            findRMDBean.setTerminated(false);
            List rmdBeans = storageManager.getRMDBeanMgr().find(findRMDBean);
            Iterator sequences = rmdBeans.iterator();
            while (sequences.hasNext()) {
                RMDBean sequence = (RMDBean)sequences.next();
                String sequenceId = sequence.getSequenceID();
                if (acked.contains(sequenceId) || sequence.getHighestInMessageNumber() <= 0L) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Piggybacking ack for sequence: " + sequenceId));
                }
                RMMsgCreator.addAckMessage(rmMessageContext, sequenceId, sequence);
                acked.add(sequenceId);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementManager::piggybackAcksIfPresent");
        }
        return transaction;
    }

    public static RMMsgContext generateAckMessage(RMMsgContext referenceRMMessage, RMDBean rmdBean, String sequenceId, StorageManager storageManager, boolean serverSide) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: AcknowledgementManager::generateAckMessage " + rmdBean));
        }
        MessageContext referenceMsg = referenceRMMessage.getMessageContext();
        EndpointReference acksTo = new EndpointReference(rmdBean.getAcksToEPR());
        if (acksTo.getAddress() == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("acksToStrNotSet"));
        }
        AxisOperation ackOperation = SpecSpecificConstants.getWSRMOperation(4, rmdBean.getRMVersion(), referenceMsg.getAxisService());
        MessageContext ackMsgCtx = SandeshaUtil.createNewRelatedMessageContext(referenceRMMessage, ackOperation);
        ackMsgCtx.setProperty("Sandesha2AppProcessingDone", (Object)"true");
        RMMsgContext ackRMMsgCtx = MsgInitializer.initializeMessage(ackMsgCtx);
        ackRMMsgCtx.setFlow(2);
        ackRMMsgCtx.setRMNamespaceValue(referenceRMMessage.getRMNamespaceValue());
        ackMsgCtx.setMessageID(SandeshaUtil.getUUID());
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(referenceMsg.getEnvelope()));
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        ackMsgCtx.setEnvelope(envelope);
        ackMsgCtx.setTo(acksTo);
        ackMsgCtx.setServerSide(serverSide);
        RMMsgCreator.addAckMessage(ackRMMsgCtx, sequenceId, rmdBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementManager::generateAckMessage");
        }
        return ackRMMsgCtx;
    }

    public static boolean verifySequenceCompletion(RangeString ackRanges, long lastMessageNo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementManager::verifySequenceCompletion");
        }
        boolean result = false;
        Range complete = new Range(1L, lastMessageNo);
        if (ackRanges.isRangeCompleted(complete)) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: AcknowledgementManager::verifySequenceCompletion " + result));
        }
        return result;
    }

    public static void addAckBeanEntry(RMMsgContext ackRMMsgContext, String sequenceId, long timeToSend, StorageManager storageManager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementManager::addAckBeanEntry");
        }
        ackRMMsgContext.addSOAPEnvelope();
        MessageContext ackMsgContext = ackRMMsgContext.getMessageContext();
        SenderBeanMgr retransmitterBeanMgr = storageManager.getSenderBeanMgr();
        String key = SandeshaUtil.getUUID();
        SenderBean ackBean = new SenderBean();
        ackBean.setMessageContextRefKey(key);
        ackBean.setMessageID(ackMsgContext.getMessageID());
        ackBean.setReSend(false);
        ackBean.setSequenceID(sequenceId);
        EndpointReference to = ackMsgContext.getTo();
        if (to != null) {
            ackBean.setToAddress(to.getAddress());
        }
        ackBean.setSend(true);
        ackMsgContext.setProperty("Sandesha2QualifiedForSending", (Object)"false");
        ackBean.setMessageType(4);
        SenderBean findBean = new SenderBean();
        findBean.setMessageType(4);
        findBean.setSend(true);
        findBean.setReSend(false);
        findBean.setSequenceID(sequenceId);
        List coll = retransmitterBeanMgr.find(findBean);
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            SenderBean oldAckBean = (SenderBean)it.next();
            if (oldAckBean.getTimeToSend() < timeToSend) {
                timeToSend = oldAckBean.getTimeToSend();
            }
            retransmitterBeanMgr.delete(oldAckBean.getMessageID());
            storageManager.removeMessageContext(oldAckBean.getMessageContextRefKey());
        }
        ackBean.setTimeToSend(timeToSend);
        ackMsgContext.setProperty("Sandesha2QualifiedForSending", (Object)"false");
        ackMsgContext.setProperty("Sandesha2SetSendToTrue", (Object)"true");
        SandeshaUtil.executeAndStore(ackRMMsgContext, key);
        retransmitterBeanMgr.insert(ackBean);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementManager::addAckBeanEntry");
        }
    }

    public static void sendAckNow(RMMsgContext ackRMMsgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AcknowledgementManager::sendAckNow");
        }
        ackRMMsgContext.addSOAPEnvelope();
        MessageContext ackMsgContext = ackRMMsgContext.getMessageContext();
        if (ackRMMsgContext.getMessageContext().getOperationContext() == null) {
            AxisOperation op = ackMsgContext.getAxisOperation();
            OperationContext opCtx = OperationContextFactory.createOperationContext((int)op.getAxisSpecificMEPConstant(), (AxisOperation)op, (ServiceContext)ackRMMsgContext.getMessageContext().getServiceContext());
            ackRMMsgContext.getMessageContext().setOperationContext(opCtx);
        }
        ackRMMsgContext.getMessageContext().setServerSide(true);
        AxisEngine.send((MessageContext)ackMsgContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: AcknowledgementManager::sendAckNow");
        }
    }
}

