/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.Sequence;

public class LastMessageProcessor
implements MsgProcessor {
    public boolean processInMessage(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        LastMessageProcessor.processLastMessage(rmMsgCtx);
        return true;
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx) {
        return false;
    }

    public static void processLastMessage(RMMsgContext rmMsgCtx) throws AxisFault {
        if (!"Spec_2005_02".equals(rmMsgCtx.getRMSpecVersion())) {
            return;
        }
        Sequence sequence = (Sequence)rmMsgCtx.getMessagePart(6);
        String sequenceId = sequence.getIdentifier().getIdentifier();
        ConfigurationContext configurationContext = rmMsgCtx.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, (AxisDescription)configurationContext.getAxisConfiguration());
        RMDBeanMgr rmdMgr = storageManager.getRMDBeanMgr();
        RMDBean rmdBean = rmdMgr.retrieve(sequenceId);
        String outBoundInternalSequence = rmdBean.getOutboundInternalSequence();
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        RMSBean findBean = new RMSBean();
        findBean.setInternalSequenceID(outBoundInternalSequence);
        RMSBean rmsBean = rmsBeanMgr.findUnique(findBean);
        if (rmsBean != null && rmsBean.getLastOutMessage() <= 0L) {
            MessageContext msgContext = rmMsgCtx.getMessageContext();
            AxisOperation operation = SpecSpecificConstants.getWSRMOperation(12, rmMsgCtx.getRMSpecVersion(), msgContext.getAxisService());
            MessageContext outMessageContext = SandeshaUtil.createNewRelatedMessageContext(rmMsgCtx, operation);
            outMessageContext.setServerSide(true);
            outMessageContext.setTransportOut(msgContext.getTransportOut());
            outMessageContext.setProperty("OutTransportInfo", msgContext.getProperty("OutTransportInfo"));
            outMessageContext.setProperty("TRANSPORT_OUT", msgContext.getProperty("TRANSPORT_OUT"));
            SOAPFactory factory = (SOAPFactory)msgContext.getEnvelope().getOMFactory();
            SOAPEnvelope envelope = factory.getDefaultEnvelope();
            outMessageContext.setEnvelope(envelope);
            if (outMessageContext.getOptions() == null) {
                outMessageContext.setOptions(new Options());
            }
            OperationContext operationContext = outMessageContext.getOperationContext();
            String inboundSequenceId = (String)msgContext.getProperty("Sandesha2InboundSequenceId");
            operationContext.setProperty("Sandesha2InboundSequenceId", (Object)inboundSequenceId);
            Long inboundMSgNo = (Long)msgContext.getProperty("Sandesha2InboundMessageNumber");
            operationContext.setProperty("Sandesha2InboundMessageNumber", (Object)inboundMSgNo);
            outMessageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
            outMessageContext.setProperty("Sandesha2InboundLastMessage", (Object)Boolean.TRUE);
            outMessageContext.setProperty("RequestResponseTransportControl", msgContext.getProperty("RequestResponseTransportControl"));
            AxisEngine.send((MessageContext)outMessageContext);
            TransportUtils.setResponseWritten((MessageContext)msgContext, (boolean)true);
        }
    }
}

