/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.WSRMMessageSender;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;

public class CloseSequenceProcessor
extends WSRMMessageSender
implements MsgProcessor {
    private static final Log log = LogFactory.getLog((Class)CloseSequenceProcessor.class);

    public boolean processInMessage(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: CloseSequenceProcessor::processInMessage");
        }
        ConfigurationContext configCtx = rmMsgCtx.getMessageContext().getConfigurationContext();
        CloseSequence closeSequence = (CloseSequence)rmMsgCtx.getMessagePart(12);
        MessageContext msgCtx = rmMsgCtx.getMessageContext();
        String sequenceId = closeSequence.getIdentifier().getIdentifier();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx, (AxisDescription)configCtx.getAxisConfiguration());
        RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceId);
        if (rmdBean != null && rmdBean.getSecurityTokenData() != null) {
            SecurityManager secManager = SandeshaUtil.getSecurityManager(msgCtx.getConfigurationContext());
            SOAPBody body = msgCtx.getEnvelope().getBody();
            SecurityToken token = secManager.recoverSecurityToken(rmdBean.getSecurityTokenData());
            secManager.checkProofOfPossession(token, (OMElement)body, msgCtx);
        }
        if (FaultManager.checkForUnknownSequence(rmMsgCtx, sequenceId, storageManager, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: CloseSequenceProcessor::processInMessage, Unknown sequence " + sequenceId));
            }
            return false;
        }
        if (FaultManager.checkForSequenceTerminated(rmMsgCtx, sequenceId, rmdBean, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: CloseSequenceProcessor::processInMessage, Sequence terminated");
            }
            return false;
        }
        rmdBean.setClosed(true);
        storageManager.getRMDBeanMgr().update(rmdBean);
        RMMsgContext ackRMMsgCtx = AcknowledgementManager.generateAckMessage(rmMsgCtx, rmdBean, sequenceId, storageManager, true);
        Iterator sequenceAckIter = ackRMMsgCtx.getMessageParts(7);
        RMMsgContext closeSeqResponseRMMsg = RMMsgCreator.createCloseSeqResponseMsg(rmMsgCtx, rmdBean);
        MessageContext closeSequenceResponseMsg = closeSeqResponseRMMsg.getMessageContext();
        while (sequenceAckIter.hasNext()) {
            SequenceAcknowledgement sequenceAcknowledgement = (SequenceAcknowledgement)sequenceAckIter.next();
            closeSeqResponseRMMsg.setMessagePart(7, sequenceAcknowledgement);
        }
        closeSeqResponseRMMsg.setFlow(2);
        closeSeqResponseRMMsg.setProperty("Sandesha2AppProcessingDone", "true");
        closeSequenceResponseMsg.setResponseWritten(true);
        closeSeqResponseRMMsg.addSOAPEnvelope();
        if (transaction != null && transaction.isActive()) {
            transaction.commit();
            transaction = null;
        }
        try {
            AxisEngine.send((MessageContext)closeSequenceResponseMsg);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("couldNotSendCloseResponse", sequenceId, e.toString());
            throw new SandeshaException(message, (Exception)((Object)e));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: CloseSequenceProcessor::processInMessage " + Boolean.FALSE));
        }
        return false;
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: CloseSequenceProcessor::processOutMessage");
        }
        this.setupOutMessage(rmMsgCtx);
        this.getRMSBean().setSequenceClosedClient(true);
        this.getStorageManager().getRMSBeanMgr().update(this.getRMSBean());
        AxisOperation closeOperation = SpecSpecificConstants.getWSRMOperation(5, rmMsgCtx.getRMSpecVersion(), rmMsgCtx.getMessageContext().getAxisService());
        this.getMsgContext().setAxisOperation(closeOperation);
        OperationContext opcontext = OperationContextFactory.createOperationContext((int)closeOperation.getAxisSpecificMEPConstant(), (AxisOperation)closeOperation, (ServiceContext)this.getMsgContext().getServiceContext());
        opcontext.setParent((AbstractContext)this.getMsgContext().getServiceContext());
        this.getConfigurationContext().registerOperationContext(rmMsgCtx.getMessageId(), opcontext);
        this.getMsgContext().setOperationContext(opcontext);
        CloseSequence closeSequencePart = (CloseSequence)rmMsgCtx.getMessagePart(12);
        Identifier identifier = closeSequencePart.getIdentifier();
        if (identifier == null) {
            identifier = new Identifier(closeSequencePart.getNamespaceValue());
            closeSequencePart.setIdentifier(identifier);
        }
        rmMsgCtx.setWSAAction(SpecSpecificConstants.getCloseSequenceAction(this.getRMVersion()));
        rmMsgCtx.setSOAPAction(SpecSpecificConstants.getCloseSequenceAction(this.getRMVersion()));
        this.sendOutgoingMessage(rmMsgCtx, 5, 0L);
        rmMsgCtx.pause();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: CloseSeqMsgProcessor::processOutMessage " + Boolean.TRUE));
        }
        return true;
    }
}

