/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.OperationContextFactory;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.WSRMMessageSender;
import org.apache.sandesha2.wsrm.AckRequested;

public class AckRequestedProcessor
extends WSRMMessageSender {
    private static final Log log = LogFactory.getLog((Class)AckRequestedProcessor.class);

    public boolean processAckRequestedHeaders(RMMsgContext message) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AckRequestedProcessor::processAckRequestHeaders");
        }
        SOAPEnvelope envelope = message.getMessageContext().getEnvelope();
        SOAPHeader header = envelope.getHeader();
        boolean msgCtxPaused = false;
        if (header != null) {
            for (int i = 0; i < Sandesha2Constants.SPEC_NS_URIS.length; ++i) {
                QName headerName = new QName(Sandesha2Constants.SPEC_NS_URIS[i], "AckRequested");
                Iterator acks = header.getChildrenWithName(headerName);
                while (acks.hasNext()) {
                    OMElement ack = (OMElement)acks.next();
                    AckRequested ackReq = new AckRequested(headerName.getNamespaceURI());
                    ackReq.fromOMElement(ack);
                    boolean paused = this.processAckRequestedHeader(message, ack, ackReq);
                    if (msgCtxPaused) continue;
                    msgCtxPaused = paused;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: AckRequestedProcessor::processAckRequestHeaders " + msgCtxPaused));
        }
        return msgCtxPaused;
    }

    public boolean processAckRequestedHeader(RMMsgContext rmMsgCtx, OMElement soapHeader, AckRequested ackRequested) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: AckRequestedProcessor::processAckRequestedHeader " + soapHeader));
        }
        boolean piggybackedAckRequest = rmMsgCtx.getMessageType() != 8;
        String sequenceId = ackRequested.getIdentifier().getIdentifier();
        MessageContext msgContext = rmMsgCtx.getMessageContext();
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, (AxisDescription)configurationContext.getAxisConfiguration());
        RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceId);
        if (rmdBean != null && rmdBean.getSecurityTokenData() != null) {
            SecurityManager secManager = SandeshaUtil.getSecurityManager(configurationContext);
            SecurityToken token = secManager.recoverSecurityToken(rmdBean.getSecurityTokenData());
            secManager.checkProofOfPossession(token, soapHeader, msgContext);
        }
        if (FaultManager.checkForUnknownSequence(rmMsgCtx, sequenceId, storageManager, piggybackedAckRequest)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AckRequestedProcessor::processAckRequestedHeader, Unknown sequence ");
            }
            return false;
        }
        if (FaultManager.checkForSequenceTerminated(rmMsgCtx, sequenceId, rmdBean, piggybackedAckRequest)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: AckRequestedProcessor::processAckRequestedHeader, Sequence terminated");
            }
            return false;
        }
        EndpointReference acksTo = new EndpointReference(rmdBean.getAcksToEPR());
        String acksToStr = acksTo.getAddress();
        if (acksToStr == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("acksToStrNotSet"));
        }
        AxisOperation ackOperation = SpecSpecificConstants.getWSRMOperation(4, rmdBean.getRMVersion(), msgContext.getAxisService());
        MessageContext ackMsgCtx = SandeshaUtil.createNewRelatedMessageContext(rmMsgCtx, ackOperation);
        RMMsgContext ackRMMsgCtx = MsgInitializer.initializeMessage(ackMsgCtx);
        ackRMMsgCtx.setRMNamespaceValue(rmMsgCtx.getRMNamespaceValue());
        ackMsgCtx.setTo(acksTo);
        ackRMMsgCtx.setRMNamespaceValue(rmMsgCtx.getRMNamespaceValue());
        if (ackMsgCtx.getMessageID() == null) {
            ackMsgCtx.setMessageID(SandeshaUtil.getUUID());
        }
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(msgContext.getEnvelope()));
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        try {
            ackMsgCtx.setEnvelope(envelope);
        }
        catch (AxisFault e3) {
            throw new SandeshaException(e3.getMessage());
        }
        ackMsgCtx.setReplyTo(msgContext.getTo());
        RMMsgCreator.addAckMessage(ackRMMsgCtx, sequenceId, rmdBean);
        ackMsgCtx.setServerSide(true);
        if (acksTo.hasAnonymousAddress()) {
            if (rmMsgCtx.getMessageContext().getOperationContext() == null) {
                ServiceContext serviceCtx = msgContext.getServiceContext();
                OperationContext opCtx = OperationContextFactory.createOperationContext((int)ackOperation.getAxisSpecificMEPConstant(), (AxisOperation)ackOperation, (ServiceContext)serviceCtx);
                rmMsgCtx.getMessageContext().setOperationContext(opCtx);
            }
            try {
                AxisEngine.send((MessageContext)ackMsgCtx);
                TransportUtils.setResponseWritten((MessageContext)ackMsgCtx, (boolean)true);
            }
            catch (AxisFault e1) {
                throw new SandeshaException(e1.getMessage());
            }
        } else {
            SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
            String key = SandeshaUtil.getUUID();
            SenderBean ackBean = new SenderBean();
            ackBean.setMessageContextRefKey(key);
            ackBean.setMessageID(ackMsgCtx.getMessageID());
            ackBean.setReSend(false);
            ackBean.setSequenceID(sequenceId);
            EndpointReference to = ackMsgCtx.getTo();
            if (to != null) {
                ackBean.setToAddress(to.getAddress());
            }
            ackBean.setSend(true);
            ackMsgCtx.setProperty("Sandesha2QualifiedForSending", (Object)"false");
            ackBean.setMessageType(4);
            SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean((AxisDescription)msgContext.getAxisMessage());
            long ackInterval = propertyBean.getAcknowledgementInterval();
            long timeToSend = System.currentTimeMillis() + ackInterval;
            SenderBean findBean = new SenderBean();
            findBean.setMessageType(4);
            List coll = senderBeanMgr.find(findBean);
            Iterator it = coll.iterator();
            if (it.hasNext()) {
                SenderBean oldAckBean = (SenderBean)it.next();
                timeToSend = oldAckBean.getTimeToSend();
                senderBeanMgr.delete(oldAckBean.getMessageID());
            }
            ackBean.setTimeToSend(timeToSend);
            msgContext.setProperty("Sandesha2QualifiedForSending", (Object)"false");
            SandeshaUtil.executeAndStore(ackRMMsgCtx, key);
            senderBeanMgr.insert(ackBean);
            msgContext.pause();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: AckRequestedProcessor::processAckRequestedHeader " + Boolean.TRUE));
            }
        }
        return false;
    }

    public boolean processOutgoingAckRequestMessage(RMMsgContext ackRequestRMMsg) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: AckRequestedProcessor::processOutgoingAckRequestMessage");
        }
        this.setupOutMessage(ackRequestRMMsg);
        AxisOperation ackOperation = SpecSpecificConstants.getWSRMOperation(4, this.getRMVersion(), this.getMsgContext().getAxisService());
        this.getMsgContext().setAxisOperation(ackOperation);
        ServiceContext serviceCtx = this.getMsgContext().getServiceContext();
        OperationContext opcontext = OperationContextFactory.createOperationContext((int)ackOperation.getAxisSpecificMEPConstant(), (AxisOperation)ackOperation, (ServiceContext)serviceCtx);
        opcontext.setParent((AbstractContext)this.getMsgContext().getServiceContext());
        this.getConfigurationContext().registerOperationContext(ackRequestRMMsg.getMessageId(), opcontext);
        this.getMsgContext().setOperationContext(opcontext);
        Iterator iterator = ackRequestRMMsg.getMessageParts(15);
        AckRequested ackRequested = null;
        while (iterator.hasNext()) {
            ackRequested = (AckRequested)iterator.next();
        }
        if (iterator.hasNext()) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("ackRequestMultipleParts"));
        }
        if (ackRequested == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("noAckRequestPartFound"));
        }
        ackRequestRMMsg.setWSAAction(SpecSpecificConstants.getAckRequestAction(this.getRMVersion()));
        ackRequestRMMsg.setSOAPAction(SpecSpecificConstants.getAckRequestSOAPAction(this.getRMVersion()));
        this.sendOutgoingMessage(ackRequestRMMsg, 8, 0L);
        ackRequestRMMsg.pause();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: AckRequestedProcessor::processOutgoingAckRequestMessage " + Boolean.TRUE));
        }
        return true;
    }
}

