/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.statistics.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.statistics.StatisticsCollector;
import org.apache.synapse.statistics.StatisticsStack;

public class SequenceStatisticsStack
implements StatisticsStack {
    private List sequenceStatisticsList = new ArrayList();

    public void put(String sequenceName, long initTime, boolean isInFlow, boolean isStatisticsEnable, boolean isFault) {
        this.sequenceStatisticsList.add(new SequenceStatistics(sequenceName, initTime, isInFlow, isStatisticsEnable, isFault));
    }

    public void reportToStatisticsCollector(StatisticsCollector statisticsCollector, boolean isFault) {
        int top = this.sequenceStatisticsList.size();
        if (top > 0) {
            this.popSequenceStatistics(this.sequenceStatisticsList.size() - 1, statisticsCollector);
        }
    }

    public void reportToStatisticsCollector(StatisticsCollector statisticsCollector, boolean isFault, String name) {
        if (!this.sequenceStatisticsList.isEmpty()) {
            ArrayList<SequenceStatistics> tobeRemoved = new ArrayList<SequenceStatistics>();
            for (SequenceStatistics sequenceStatistics : this.sequenceStatisticsList) {
                if (sequenceStatistics == null) continue;
                if (sequenceStatistics.isStatisticsEnable && sequenceStatistics.sequenceName != null && sequenceStatistics.sequenceName.equals(name)) {
                    statisticsCollector.reportForSequence(sequenceStatistics.sequenceName, !sequenceStatistics.isInFlow, sequenceStatistics.initTime, System.currentTimeMillis(), sequenceStatistics.isFault);
                }
                tobeRemoved.add(sequenceStatistics);
            }
            this.sequenceStatisticsList.removeAll(tobeRemoved);
        }
    }

    public void reportAllToStatisticsCollector(StatisticsCollector statisticsCollector, boolean isFault) {
        for (int i = this.sequenceStatisticsList.size() - 1; i >= 0; --i) {
            this.popSequenceStatistics(i, statisticsCollector);
        }
    }

    private void popSequenceStatistics(int index, StatisticsCollector statisticsCollector) {
        SequenceStatistics sequenceStatistics;
        if (index >= 0 && (sequenceStatistics = (SequenceStatistics)this.sequenceStatisticsList.get(index)) != null) {
            if (sequenceStatistics.isStatisticsEnable && sequenceStatistics.sequenceName != null) {
                statisticsCollector.reportForSequence(sequenceStatistics.sequenceName, !sequenceStatistics.isInFlow, sequenceStatistics.initTime, System.currentTimeMillis(), sequenceStatistics.isFault);
            }
            this.sequenceStatisticsList.remove(index);
        }
    }

    class SequenceStatistics {
        String sequenceName;
        long initTime;
        boolean isInFlow;
        boolean isStatisticsEnable;
        private boolean isFault;

        public SequenceStatistics(String sequenceName, long initTime, boolean inFlow, boolean statisticsEnable, boolean isFault) {
            this.sequenceName = sequenceName;
            this.initTime = initTime;
            this.isInFlow = inFlow;
            this.isStatisticsEnable = statisticsEnable;
            this.isFault = isFault;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SequenceStatistics that = (SequenceStatistics)o;
            return this.sequenceName.equals(that.sequenceName);
        }

        public int hashCode() {
            return this.sequenceName.hashCode();
        }
    }
}

