/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.statistics.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.statistics.StatisticsCollector;
import org.apache.synapse.statistics.StatisticsStack;

public class EndPointStatisticsStack
implements StatisticsStack {
    private List endpointStatistics;
    private boolean isCompleteInFlowStatisicsReport = false;

    public void put(String key, long initTime, boolean isInFlow, boolean isStatisticsEnable, boolean isFault) {
        if (this.endpointStatistics == null) {
            this.endpointStatistics = new ArrayList();
        }
        this.endpointStatistics.add(new EndPointStatistics(key, initTime, isInFlow, isStatisticsEnable, isFault));
    }

    public void reportToStatisticsCollector(StatisticsCollector statisticsCollector, boolean isFault) {
        EndPointStatistics statistics;
        if (this.endpointStatistics != null && !this.endpointStatistics.isEmpty() && (statistics = (EndPointStatistics)this.endpointStatistics.get(this.endpointStatistics.size() - 1)) != null && statistics.isStatisticsEnable && statistics.endPointName != null) {
            if (statistics.inTimeForInFlow != -1L) {
                long initTimeForOutFlow = System.currentTimeMillis();
                statisticsCollector.reportForEndPoint(statistics.endPointName, false, statistics.inTimeForInFlow, initTimeForOutFlow, isFault);
                statistics.inTimeForInFlow = -1L;
                statistics.inTimeForOutFlow = initTimeForOutFlow;
            } else if (statistics.inTimeForOutFlow != -1L && this.isCompleteInFlowStatisicsReport) {
                statisticsCollector.reportForEndPoint(statistics.endPointName, true, statistics.inTimeForOutFlow, System.currentTimeMillis(), isFault);
                this.endpointStatistics.remove(statistics);
            }
        }
    }

    public void reportToStatisticsCollector(StatisticsCollector statisticsCollector, boolean isFault, String name) {
        if (this.endpointStatistics != null && !this.endpointStatistics.isEmpty()) {
            ArrayList<EndPointStatistics> tobeRemoved = new ArrayList<EndPointStatistics>();
            for (Object statisticsObj : this.endpointStatistics) {
                EndPointStatistics statistics;
                if (!(statisticsObj instanceof EndPointStatistics) || !(statistics = (EndPointStatistics)statisticsObj).isStatisticsEnable || statistics.endPointName == null || !statistics.endPointName.equals(name)) continue;
                if (statistics.inTimeForInFlow != -1L) {
                    long initTimeForOutFlow = System.currentTimeMillis();
                    statisticsCollector.reportForEndPoint(statistics.endPointName, false, statistics.inTimeForInFlow, initTimeForOutFlow, isFault);
                    statistics.inTimeForInFlow = -1L;
                    statistics.inTimeForOutFlow = initTimeForOutFlow;
                    continue;
                }
                if (statistics.inTimeForOutFlow == -1L || !this.isCompleteInFlowStatisicsReport) continue;
                statisticsCollector.reportForEndPoint(statistics.endPointName, true, statistics.inTimeForOutFlow, System.currentTimeMillis(), isFault);
                tobeRemoved.add(statistics);
            }
            this.endpointStatistics.removeAll(tobeRemoved);
        }
    }

    public void reportAllToStatisticsCollector(StatisticsCollector statisticsCollector, boolean isFault) {
        if (this.endpointStatistics != null && !this.endpointStatistics.isEmpty()) {
            ArrayList<EndPointStatistics> tobeRemoved = new ArrayList<EndPointStatistics>();
            for (Object statisticsObj : this.endpointStatistics) {
                EndPointStatistics statistics;
                if (!(statisticsObj instanceof EndPointStatistics) || !(statistics = (EndPointStatistics)statisticsObj).isStatisticsEnable || statistics.endPointName == null) continue;
                if (statistics.inTimeForInFlow != -1L) {
                    long initTimeForOutFlow = System.currentTimeMillis();
                    statisticsCollector.reportForEndPoint(statistics.endPointName, false, statistics.inTimeForInFlow, initTimeForOutFlow, isFault);
                    statistics.inTimeForInFlow = -1L;
                    statistics.inTimeForOutFlow = initTimeForOutFlow;
                    continue;
                }
                if (statistics.inTimeForOutFlow == -1L || !this.isCompleteInFlowStatisicsReport) continue;
                statisticsCollector.reportForEndPoint(statistics.endPointName, true, statistics.inTimeForOutFlow, System.currentTimeMillis(), isFault);
                tobeRemoved.add(statistics);
            }
            this.endpointStatistics.removeAll(tobeRemoved);
        }
        this.isCompleteInFlowStatisicsReport = true;
    }

    class EndPointStatistics {
        private String endPointName;
        private boolean isStatisticsEnable;
        private boolean isFault;
        private long inTimeForInFlow = -1L;
        private long inTimeForOutFlow = -1L;

        public EndPointStatistics(String endPointName, long initTime, boolean inFlow, boolean statisticsEnable, boolean fault) {
            if (inFlow) {
                this.endPointName = endPointName;
                this.inTimeForInFlow = initTime;
                this.isStatisticsEnable = statisticsEnable;
                this.isFault = fault;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndPointStatistics that = (EndPointStatistics)o;
            return !(this.endPointName != null ? !this.endPointName.equals(that.endPointName) : that.endPointName != null);
        }

        public int hashCode() {
            return this.endPointName != null ? this.endPointName.hashCode() : 0;
        }
    }
}

