/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.quartz;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.PropertyHelper;
import org.apache.synapse.config.xml.StartupFactory;
import org.apache.synapse.startup.quartz.SimpleQuartz;
import org.apache.synapse.startup.quartz.SimpleQuartzSerializer;

public class SimpleQuartzFactory
implements StartupFactory {
    public static final QName TASK = new QName("http://ws.apache.org/ns/synapse", "task");
    private static final QName TRIGGER = new QName("http://ws.apache.org/ns/synapse", "trigger");
    private static final QName PROPERTY = new QName("http://ws.apache.org/ns/synapse", "property");
    private static final Log log = LogFactory.getLog(SimpleQuartzFactory.class);

    public Startup createStartup(OMElement el) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating SimpleQuartz Task");
        }
        if (el.getQName().equals(TASK)) {
            String pinnedServersValue;
            SimpleQuartz q = new SimpleQuartz();
            String name = el.getAttributeValue(new QName("", "name"));
            if (name != null) {
                q.setName(name);
            } else {
                this.handleException("Name for a task is required, missing name in the task");
            }
            OMAttribute classAttr = el.getAttribute(new QName("class"));
            if (classAttr != null && classAttr.getAttributeValue() != null) {
                String classname = classAttr.getAttributeValue();
                try {
                    Class.forName(classname).newInstance();
                }
                catch (Exception e) {
                    this.handleException("Failed to load task class " + classname, e);
                }
                q.setJobClass(classname);
            } else {
                this.handleException("Syntax error in the Task : no task class specified");
            }
            OMAttribute pinnedServers = el.getAttribute(new QName("", "pinnedServers"));
            if (pinnedServers != null && (pinnedServersValue = pinnedServers.getAttributeValue()) != null) {
                StringTokenizer st = new StringTokenizer(pinnedServersValue, " ,");
                ArrayList<String> pinnedServersList = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.length() == 0) continue;
                    pinnedServersList.add(token);
                }
                q.setPinnedServers(pinnedServersList);
            }
            Iterator it = el.getChildrenWithName(PROPERTY);
            while (it.hasNext()) {
                OMElement prop = (OMElement)it.next();
                if (PropertyHelper.isStaticProperty(prop)) {
                    q.addProperty(prop);
                    continue;
                }
                this.handleException("Tasks does not support dynamic properties");
            }
            OMElement trigger = el.getFirstChildWithName(TRIGGER);
            if (trigger != null) {
                OMAttribute repeatInterval;
                OMAttribute once;
                OMAttribute count = trigger.getAttribute(new QName("count"));
                if (count != null) {
                    try {
                        q.setCount(Integer.parseInt(count.getAttributeValue()));
                    }
                    catch (Exception e) {
                        this.handleException("Failed to parse trigger count as an integer", e);
                    }
                }
                if ((once = trigger.getAttribute(new QName("once"))) != null && Boolean.TRUE.toString().equals(once.getAttributeValue())) {
                    q.setCount(1);
                    q.setInterval(1L);
                }
                if ((repeatInterval = trigger.getAttribute(new QName("interval"))) == null && q.getCount() > 1) {
                    this.handleException("Trigger seems to be a simple trigger, but no interval specified");
                } else if (repeatInterval != null && repeatInterval.getAttributeValue() != null) {
                    try {
                        long repeatIntervalInSeconds = Long.parseLong(repeatInterval.getAttributeValue());
                        long repeatIntervalInMillis = repeatIntervalInSeconds * 1000L;
                        q.setInterval(repeatIntervalInMillis);
                    }
                    catch (Exception e) {
                        this.handleException("Failed to parse trigger interval as a long value", e);
                    }
                }
                OMAttribute expr = trigger.getAttribute(new QName("cron"));
                if (expr == null && q.getInterval() == 0L) {
                    q.setCount(1);
                    q.setInterval(1L);
                } else if (expr != null && q.getInterval() > 0L) {
                    this.handleException("Trigger syntax error : both cron and simple trigger attributes are present");
                } else if (expr != null && expr.getAttributeValue() != null) {
                    q.setCron(expr.getAttributeValue());
                }
            } else {
                q.setCount(1);
                q.setInterval(1L);
            }
            return q;
        }
        this.handleException("Syntax error in the task : wrong QName for the task");
        return null;
    }

    public Class getSerializerClass() {
        return SimpleQuartzSerializer.class;
    }

    public QName getTagQName() {
        return TASK;
    }

    private void handleException(String message, Exception e) {
        log.error((Object)message);
        throw new SynapseException(message, e);
    }

    private void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

