/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.xml.SwitchCase;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;

public class SwitchMediator
extends AbstractMediator {
    private AXIOMXPath source = null;
    private List cases = new ArrayList();
    private SwitchCase defaultCase = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Switch mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        int parentsEffectiveTraceState = synCtx.getTracingState();
        this.setEffectiveTraceState(synCtx);
        int myEffectiveTraceState = synCtx.getTracingState();
        String sourceText = Axis2MessageContext.getStringValue(this.source, synCtx);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "XPath : " + this.source + " evaluates to : " + sourceText);
        }
        try {
            if ((sourceText == null || this.cases.isEmpty()) && this.defaultCase != null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Source XPath evaluated to : null or no switch cases found. Executing the default case");
                }
                boolean bl = this.defaultCase.mediate(synCtx);
                return bl;
            }
            for (SwitchCase swCase : this.cases) {
                if (swCase == null || !swCase.matches(sourceText)) continue;
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Matching case found : " + swCase.getRegex());
                }
                boolean bl = swCase.mediate(synCtx);
                return bl;
            }
            if (this.defaultCase != null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "None of the switch cases matched - executing default");
                }
                boolean bl = this.defaultCase.mediate(synCtx);
                return bl;
            }
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "None of the switch cases matched - no default case");
            }
        }
        finally {
            synCtx.setTracingState(parentsEffectiveTraceState);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Switch mediator");
        }
        return true;
    }

    public void addCase(SwitchCase m) {
        this.cases.add(m);
    }

    public List getCases() {
        return this.cases;
    }

    public AXIOMXPath getSource() {
        return this.source;
    }

    public void setSource(AXIOMXPath source) {
        this.source = source;
    }

    public SwitchCase getDefaultCase() {
        return this.defaultCase;
    }

    public void setDefaultCase(SwitchCase defaultCase) {
        this.defaultCase = defaultCase;
    }
}

