/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractListMediator;
import org.jaxen.JaxenException;

public class FilterMediator
extends AbstractListMediator
implements org.apache.synapse.mediators.FilterMediator {
    private AXIOMXPath source = null;
    private Pattern regex = null;
    private AXIOMXPath xpath = null;

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Filter mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        boolean result = false;
        if (this.test(synCtx)) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, (this.xpath == null ? "Source : " + this.source + " against : " + this.regex.pattern() + " matches" : "XPath expression : " + this.xpath + " evaluates to true") + " - executing child mediators");
            }
            result = super.mediate(synCtx);
        } else {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, (this.xpath == null ? "Source : " + this.source + " against : " + this.regex.pattern() + " does not match" : "XPath expression : " + this.xpath + " evaluates to false") + " - skipping child mediators");
            }
            result = true;
        }
        if (traceOrDebugOn) {
            trace.trace((Object)"End : Filter mediator ");
        }
        return result;
    }

    public boolean test(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (this.xpath != null) {
            try {
                return this.xpath.booleanValueOf((Object)synCtx.getEnvelope());
            }
            catch (JaxenException e) {
                this.handleException("Error evaluating XPath expression : " + this.xpath, (Exception)((Object)e), synCtx);
            }
        } else if (this.source != null && this.regex != null) {
            String sourceString = Axis2MessageContext.getStringValue(this.source, synCtx);
            if (sourceString == null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Source String : " + this.source + " evaluates to null");
                }
                return false;
            }
            Matcher matcher = this.regex.matcher(sourceString);
            if (matcher == null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Regex pattren matcher for : " + this.regex.pattern() + "against source : " + sourceString + " is null");
                }
                return false;
            }
            return matcher.matches();
        }
        return false;
    }

    public AXIOMXPath getSource() {
        return this.source;
    }

    public void setSource(AXIOMXPath source) {
        this.source = source;
    }

    public Pattern getRegex() {
        return this.regex;
    }

    public void setRegex(Pattern regex) {
        this.regex = regex;
    }

    public AXIOMXPath getXpath() {
        return this.xpath;
    }

    public void setXpath(AXIOMXPath xpath) {
        this.xpath = xpath;
    }
}

