/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.ext;

import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;

public class ClassMediator
extends AbstractMediator
implements ManagedLifecycle {
    private Mediator mediator = null;
    private Map properties = new HashMap();

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Class mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "invoking : " + this.mediator.getClass() + ".mediate()");
        }
        boolean result = true;
        try {
            result = this.mediator.mediate(synCtx);
        }
        catch (Exception e) {
            throw new SynapseException("Error occured in the mediation of the class mediator", e);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Class mediator");
        }
        return result;
    }

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Destroying class mediator instance for : " + this.mediator.getClass()));
        }
        if (this.mediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.mediator)).destroy();
        }
    }

    public void init(SynapseEnvironment se) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing class mediator instance for : " + this.mediator.getClass()));
        }
        if (this.mediator == null) {
            this.log.warn((Object)"init() called before mediator reference set");
            return;
        }
        if (this.mediator instanceof ManagedLifecycle) {
            ((ManagedLifecycle)((Object)this.mediator)).init(se);
        }
    }

    public void setMediator(Mediator mediator) {
        this.mediator = mediator;
    }

    public Mediator getMediator() {
        return this.mediator;
    }

    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Map getProperties() {
        return this.properties;
    }
}

