/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.splitter;

import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.OperationContext;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.mediators.eip.Target;
import org.apache.synapse.util.MessageHelper;
import org.jaxen.JaxenException;

public class IterateMediator
extends AbstractMediator
implements ManagedLifecycle {
    private boolean continueParent = false;
    private boolean preservePayload = false;
    private AXIOMXPath expression = null;
    private AXIOMXPath attachPath = null;
    private Target target = null;

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Iterate mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        try {
            SOAPEnvelope envelope = MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope());
            List splitElements = EIPUtils.getDetachedMatchingElements(envelope, this.expression);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Splitting with XPath : " + this.expression + " resulted in " + splitElements.size() + " elements");
            }
            if (!this.preservePayload && envelope.getBody() != null) {
                Iterator itr = envelope.getBody().getChildren();
                while (itr.hasNext()) {
                    ((OMNode)itr.next()).detach();
                }
            }
            int msgCount = splitElements.size();
            int msgNumber = 0;
            for (Object o : splitElements) {
                if (!(o instanceof OMNode)) {
                    this.handleException("Error splitting message with XPath : " + this.expression + " - result not an OMNode", synCtx);
                }
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Submitting " + (msgNumber + 1) + " of " + msgNumber + " messages for processing in parallel");
                }
                this.target.mediate(this.getIteratedMessage(synCtx, msgNumber++, msgCount, envelope, (OMNode)o));
            }
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating split XPath expression : " + this.expression, (Exception)((Object)e), synCtx);
        }
        catch (AxisFault af) {
            this.handleException("Error creating an iterated copy of the message", (Exception)((Object)af), synCtx);
        }
        OperationContext opCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getOperationContext();
        if (!this.continueParent && opCtx != null) {
            opCtx.setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Iterate mediator");
        }
        return this.continueParent;
    }

    private MessageContext getIteratedMessage(MessageContext synCtx, int msgNumber, int msgCount, SOAPEnvelope envelope, OMNode o) throws AxisFault, JaxenException {
        MessageContext newCtx = MessageHelper.cloneMessageContext(synCtx);
        newCtx.setProperty("messageSequence", msgNumber + "/" + msgCount);
        SOAPEnvelope newEnvelope = MessageHelper.cloneSOAPEnvelope(envelope);
        if (this.preservePayload) {
            Object attachElem = this.attachPath.evaluate((Object)newEnvelope);
            if (attachElem != null && attachElem instanceof List && !((List)attachElem).isEmpty()) {
                attachElem = ((List)attachElem).get(0);
            }
            if (attachElem != null && attachElem instanceof OMElement) {
                ((OMElement)attachElem).addChild(o);
            } else {
                this.handleException("Error in attaching the splitted elements :: Unable to get the attach path specified by the expression " + this.attachPath, synCtx);
            }
        } else if (newEnvelope.getBody() != null) {
            newEnvelope.getBody().addChild(o);
        }
        newCtx.setEnvelope(newEnvelope);
        return newCtx;
    }

    public boolean isContinueParent() {
        return this.continueParent;
    }

    public void setContinueParent(boolean continueParent) {
        this.continueParent = continueParent;
    }

    public boolean isPreservePayload() {
        return this.preservePayload;
    }

    public void setPreservePayload(boolean preservePayload) {
        this.preservePayload = preservePayload;
    }

    public AXIOMXPath getExpression() {
        return this.expression;
    }

    public void setExpression(AXIOMXPath expression) {
        this.expression = expression;
    }

    public AXIOMXPath getAttachPath() {
        return this.attachPath;
    }

    public void setAttachPath(AXIOMXPath attachPath) {
        this.attachPath = attachPath;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public void init(SynapseEnvironment se) {
        if (this.target.getSequence() != null) {
            this.target.getSequence().init(se);
        }
    }

    public void destroy() {
        if (this.target.getSequence() != null) {
            this.target.getSequence().destroy();
        }
    }
}

