/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.eip.aggregator;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.eip.EIPUtils;
import org.apache.synapse.mediators.eip.aggregator.Aggregate;
import org.jaxen.JaxenException;

public class AggregateMediator
extends AbstractMediator {
    private static final Log log = LogFactory.getLog(AggregateMediator.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    private long completionTimeoutMillis;
    private int minMessagesToComplete;
    private int maxMessagesToComplete;
    private AXIOMXPath correlateExpression;
    private AXIOMXPath aggregationExpression;
    private String onCompleteSequenceRef;
    private SequenceMediator onCompleteSequence;
    private Map<String, Aggregate> activeAggregates;

    public AggregateMediator() {
        block2: {
            this.completionTimeoutMillis = 0L;
            this.minMessagesToComplete = -1;
            this.maxMessagesToComplete = -1;
            this.correlateExpression = null;
            this.aggregationExpression = null;
            this.onCompleteSequenceRef = null;
            this.onCompleteSequence = null;
            this.activeAggregates = Collections.synchronizedMap(new HashMap());
            try {
                this.aggregationExpression = new AXIOMXPath("s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]");
                this.aggregationExpression.addNamespace("s11", "http://schemas.xmlsoap.org/soap/envelope/");
                this.aggregationExpression.addNamespace("s12", "http://www.w3.org/2003/05/soap-envelope");
            }
            catch (JaxenException e) {
                if (!log.isDebugEnabled()) break block2;
                this.handleException("Unable to set the default aggregationExpression for the aggregation", (Exception)((Object)e), null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mediate(MessageContext synCtx) {
        boolean traceOrDebugOn;
        boolean traceOn;
        block23: {
            traceOn = this.isTraceOn(synCtx);
            traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Start : Aggregate mediator");
                if (traceOn && trace.isTraceEnabled()) {
                    trace.trace((Object)("Message : " + synCtx.getEnvelope()));
                }
            }
            try {
                Aggregate aggregate;
                block22: {
                    block25: {
                        block24: {
                            aggregate = null;
                            if (this.correlateExpression == null || this.correlateExpression.evaluate((Object)synCtx.getEnvelope()) == null) break block24;
                            if (this.activeAggregates.containsKey(this.correlateExpression.toString())) {
                                aggregate = this.activeAggregates.get(this.correlateExpression.toString());
                                break block22;
                            } else {
                                if (traceOrDebugOn) {
                                    this.traceOrDebug(traceOn, "Creating new Aggregator - expires in : " + this.completionTimeoutMillis / 1000L + "secs");
                                }
                                aggregate = new Aggregate(this.correlateExpression.toString(), this.completionTimeoutMillis, this.minMessagesToComplete, this.maxMessagesToComplete, this);
                                synCtx.getConfiguration().getSynapseTimer().schedule((TimerTask)aggregate, this.completionTimeoutMillis);
                                this.activeAggregates.put(this.correlateExpression.toString(), aggregate);
                            }
                            break block22;
                        }
                        if (synCtx.getProperty("aggregateCorelation") == null) break block25;
                        Object o = synCtx.getProperty("aggregateCorelation");
                        String correlation = null;
                        if (o != null && o instanceof String) {
                            correlation = (String)o;
                            if (this.activeAggregates.containsKey(correlation)) {
                                aggregate = this.activeAggregates.get(correlation);
                                break block22;
                            } else {
                                if (traceOrDebugOn) {
                                    this.traceOrDebug(traceOn, "Creating new Aggregator - expires in : " + this.completionTimeoutMillis / 1000L + "secs");
                                }
                                aggregate = new Aggregate(correlation, this.completionTimeoutMillis, this.minMessagesToComplete, this.maxMessagesToComplete, this);
                                synCtx.getConfiguration().getSynapseTimer().schedule((TimerTask)aggregate, this.completionTimeoutMillis);
                                this.activeAggregates.put(correlation, aggregate);
                            }
                            break block22;
                        } else {
                            if (traceOrDebugOn) {
                                this.traceOrDebug(traceOn, "Unable to find aggrgation correlation property");
                            }
                            return true;
                        }
                    }
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Unable to find aggrgation correlation XPath or property");
                    }
                    return true;
                }
                if (aggregate != null) {
                    boolean collected = aggregate.addMessage(synCtx);
                    if (traceOrDebugOn && collected) {
                        this.traceOrDebug(traceOn, "Collected a message during aggregation");
                        if (traceOn && trace.isTraceEnabled()) {
                            trace.trace((Object)("Collected message : " + synCtx));
                        }
                    }
                    if (aggregate.isComplete(traceOn, traceOrDebugOn, trace, log)) {
                        if (traceOrDebugOn) {
                            this.traceOrDebug(traceOn, "Aggregation completed - invoking onComplete");
                        }
                        this.completeAggregate(aggregate);
                        if (traceOrDebugOn) {
                            this.traceOrDebug(traceOn, "End : Aggregate mediator");
                        }
                        return true;
                    }
                    break block23;
                }
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Unable to find an aggregate for this message - skip");
                }
                return true;
            }
            catch (JaxenException e) {
                this.handleException("Unable to execute the XPATH over the message", (Exception)((Object)e), synCtx);
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Aggregate mediator");
        }
        return false;
    }

    public void completeAggregate(Aggregate aggregate) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Aggregation completed or timed out");
        }
        aggregate.cancel();
        MessageContext newSynCtx = this.getAggregatedMessage(aggregate);
        if (newSynCtx == null) {
            log.warn((Object)"An aggregation of messages timed out with no aggregated messages", null);
            return;
        }
        this.activeAggregates.remove(aggregate);
        if (this.correlateExpression != null && !this.correlateExpression.toString().equals(aggregate.getCorrelation()) || this.correlateExpression == null) {
            if (this.onCompleteSequence != null) {
                this.onCompleteSequence.mediate(newSynCtx);
            } else if (this.onCompleteSequenceRef != null && newSynCtx.getSequence(this.onCompleteSequenceRef) != null) {
                newSynCtx.getSequence(this.onCompleteSequenceRef).mediate(newSynCtx);
            } else {
                this.handleException("Unable to find the sequence for the mediation of the aggregated message", newSynCtx);
            }
        }
    }

    private MessageContext getAggregatedMessage(Aggregate aggregate) {
        MessageContext newCtx = null;
        for (MessageContext synCtx : aggregate.getMessages()) {
            if (newCtx == null) {
                newCtx = synCtx;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Generating Aggregated message from : " + newCtx.getEnvelope()));
                continue;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Merging message : " + synCtx.getEnvelope() + " using XPath : " + this.aggregationExpression));
                }
                EIPUtils.enrichEnvelope(newCtx.getEnvelope(), synCtx.getEnvelope(), this.aggregationExpression);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Merged result : " + newCtx.getEnvelope()));
            }
            catch (JaxenException e) {
                this.handleException("Error merging aggregation results using XPath : " + this.aggregationExpression.toString(), (Exception)((Object)e), synCtx);
            }
        }
        return newCtx;
    }

    public AXIOMXPath getCorrelateExpression() {
        return this.correlateExpression;
    }

    public void setCorrelateExpression(AXIOMXPath correlateExpression) {
        this.correlateExpression = correlateExpression;
    }

    public long getCompletionTimeoutMillis() {
        return this.completionTimeoutMillis;
    }

    public void setCompletionTimeoutMillis(long completionTimeoutMillis) {
        this.completionTimeoutMillis = completionTimeoutMillis;
    }

    public int getMinMessagesToComplete() {
        return this.minMessagesToComplete;
    }

    public void setMinMessagesToComplete(int minMessagesToComplete) {
        this.minMessagesToComplete = minMessagesToComplete;
    }

    public int getMaxMessagesToComplete() {
        return this.maxMessagesToComplete;
    }

    public void setMaxMessagesToComplete(int maxMessagesToComplete) {
        this.maxMessagesToComplete = maxMessagesToComplete;
    }

    public AXIOMXPath getAggregationExpression() {
        return this.aggregationExpression;
    }

    public void setAggregationExpression(AXIOMXPath aggregationExpression) {
        this.aggregationExpression = aggregationExpression;
    }

    public String getOnCompleteSequenceRef() {
        return this.onCompleteSequenceRef;
    }

    public void setOnCompleteSequenceRef(String onCompleteSequenceRef) {
        this.onCompleteSequenceRef = onCompleteSequenceRef;
    }

    public SequenceMediator getOnCompleteSequence() {
        return this.onCompleteSequence;
    }

    public void setOnCompleteSequence(SequenceMediator onCompleteSequence) {
        this.onCompleteSequence = onCompleteSequence;
    }

    public Map getActiveAggregates() {
        return this.activeAggregates;
    }
}

