/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.jaxen.JaxenException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ValidateMediator
extends AbstractListMediator {
    private List schemaKeys = new ArrayList();
    private AXIOMXPath source = null;
    private List explicityFeatures = new ArrayList();
    private Schema cachedSchema;
    private final Object validatorLock = new Object();
    private SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    public static final String DEFAULT_XPATH = "s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]";

    public ValidateMediator() {
        try {
            this.source = new AXIOMXPath(DEFAULT_XPATH);
            this.source.addNamespace("s11", "http://schemas.xmlsoap.org/soap/envelope/");
            this.source.addNamespace("s12", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (JaxenException e) {
            String msg = "Error creating default source XPath expression : s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]";
            this.log.error((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        Object propKey2;
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Validate mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        Source validateSrc = this.getValidationSource(synCtx, traceOrDebugOn, traceOn);
        boolean reCreate = false;
        for (Object propKey2 : this.schemaKeys) {
            Entry dp = synCtx.getConfiguration().getEntryDefinition((String)propKey2);
            if (dp == null || !dp.isDynamic() || dp.isCached() && !dp.isExpired()) continue;
            reCreate = true;
        }
        MyErrorHandler errorHandler = new MyErrorHandler();
        propKey2 = this.validatorLock;
        synchronized (propKey2) {
            if (reCreate || this.cachedSchema == null) {
                this.factory.setErrorHandler(errorHandler);
                Source[] sources = new StreamSource[this.schemaKeys.size()];
                int i = 0;
                for (String propName : this.schemaKeys) {
                    sources[i++] = SynapseConfigUtils.getStreamSource(synCtx.getEntry(propName));
                }
                try {
                    this.cachedSchema = this.factory.newSchema(sources);
                }
                catch (SAXException e) {
                    this.handleException("Error creating a new schema objects for schemas : " + this.schemaKeys.toString(), e, synCtx);
                }
                if (errorHandler.isValidationError()) {
                    errorHandler.setValidationError(false);
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Error creating a new schema objects for schemas : " + this.schemaKeys.toString());
                    }
                }
            }
        }
        try {
            Validator validator = this.cachedSchema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(validateSrc);
            if (errorHandler.isValidationError()) {
                if (traceOrDebugOn) {
                    String msg = "Validation of element returned by XPath : " + this.source + " failed against the given schema(s) " + this.schemaKeys + "with error : " + errorHandler.getSaxParseException().getMessage() + " Executing 'on-fail' sequence";
                    this.traceOrDebug(traceOn, msg);
                    synCtx.getServiceLog().warn((Object)msg);
                    if (traceOn && trace.isTraceEnabled()) {
                        this.log.debug((Object)("Failed message envelope : " + synCtx.getEnvelope()));
                    }
                }
                synCtx.setProperty("ERROR_MESSAGE", errorHandler.getSaxParseException().getMessage());
                synCtx.setProperty("ERROR_EXCEPTION", errorHandler.getSaxParseException());
                synCtx.setProperty("ERROR_DETAIL", FaultHandler.getStackTrace(errorHandler.getSaxParseException()));
                return super.mediate(synCtx);
            }
        }
        catch (SAXException e) {
            this.handleException("Error validating " + this.source + " element", e, synCtx);
        }
        catch (IOException e) {
            this.handleException("Error validating " + this.source + " element", e, synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Validation of element returned by the XPath expression : " + this.source + " succeeded against the given schemas and the current message");
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Validate mediator");
        }
        return true;
    }

    private Source getValidationSource(MessageContext synCtx, boolean traceOrDebugOn, boolean traceOn) {
        try {
            ByteArrayOutputStream baosForSource = new ByteArrayOutputStream();
            XMLStreamWriter xsWriterForSource = XMLOutputFactory.newInstance().createXMLStreamWriter(baosForSource);
            OMNode validateSource = this.getValidateSource(synCtx);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Validation source : " + validateSource.toString());
            }
            validateSource.serialize(xsWriterForSource);
            ByteArrayInputStream baisFromSource = new ByteArrayInputStream(baosForSource.toByteArray());
            XMLReader reader = XMLReaderFactory.createXMLReader();
            return new SAXSource(reader, new InputSource(baisFromSource));
        }
        catch (Exception e) {
            this.handleException("Error accessing source element : " + this.source, e, synCtx);
            return null;
        }
    }

    private OMNode getValidateSource(MessageContext synCtx) {
        try {
            Object o = this.source.evaluate((Object)synCtx.getEnvelope());
            if (o instanceof OMNode) {
                return (OMNode)o;
            }
            if (o instanceof List && !((List)o).isEmpty()) {
                return (OMNode)((List)o).get(0);
            }
            this.handleException("The evaluation of the XPath expression " + this.source + " did not result in an OMNode : " + o, synCtx);
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating XPath expression : " + this.source, (Exception)((Object)e), synCtx);
        }
        return null;
    }

    public Object getFeature(String key) {
        for (MediatorProperty prop : this.explicityFeatures) {
            if (!key.equals(prop.getName())) continue;
            return prop.getValue();
        }
        return null;
    }

    public void addFeature(String featureName, boolean isFeatureEnable) throws SAXException {
        MediatorProperty mp = new MediatorProperty();
        mp.setName(featureName);
        if (isFeatureEnable) {
            mp.setValue("true");
        } else {
            mp.setValue("false");
        }
        this.explicityFeatures.add(mp);
        this.factory.setFeature(featureName, isFeatureEnable);
    }

    public void setSchemaKeys(List schemaKeys) {
        this.schemaKeys = schemaKeys;
    }

    public void setSource(AXIOMXPath source) {
        this.source = source;
    }

    public AXIOMXPath getSource() {
        return this.source;
    }

    public List getSchemaKeys() {
        return this.schemaKeys;
    }

    public List getFeatures() {
        return this.explicityFeatures;
    }

    private class MyErrorHandler
    extends DefaultHandler {
        private boolean validationError = false;
        private SAXParseException saxParseException = null;

        private MyErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.validationError = true;
            this.saxParseException = exception;
        }

        public void warning(SAXParseException exception) throws SAXException {
        }

        public boolean isValidationError() {
            return this.validationError;
        }

        public SAXParseException getSaxParseException() {
            return this.saxParseException;
        }

        public void setValidationError(boolean validationError) {
            this.validationError = validationError;
        }
    }
}

