/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.synapse.MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;

public class LogMediator
extends AbstractMediator {
    public static final int CUSTOM = 0;
    public static final int SIMPLE = 1;
    public static final int HEADERS = 2;
    public static final int FULL = 3;
    public static final String DEFAULT_SEP = ", ";
    private int logLevel = 1;
    private String separator = ", ";
    private List properties = new ArrayList();

    public boolean mediate(MessageContext synCtx) {
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Log mediator");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        String logMessage = this.getLogMessage(synCtx);
        synCtx.getServiceLog().info((Object)logMessage);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)logMessage);
        }
        if (traceOn) {
            trace.info((Object)("Log message : " + logMessage));
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Log mediator");
        }
        return true;
    }

    private String getLogMessage(MessageContext synCtx) {
        switch (this.logLevel) {
            case 0: {
                return this.getCustomLogMessage(synCtx);
            }
            case 1: {
                return this.getSimpleLogMessage(synCtx);
            }
            case 2: {
                return this.getHeadersLogMessage(synCtx);
            }
            case 3: {
                return this.getFullLogMessage(synCtx);
            }
        }
        return "Invalid log level specified";
    }

    private String getCustomLogMessage(MessageContext synCtx) {
        StringBuffer sb = new StringBuffer();
        this.setCustomProperties(sb, synCtx);
        return this.trimLeadingSeparator(sb);
    }

    private String getSimpleLogMessage(MessageContext synCtx) {
        StringBuffer sb = new StringBuffer();
        if (synCtx.getTo() != null) {
            sb.append("To: " + synCtx.getTo().getAddress());
        } else {
            sb.append("To: ");
        }
        if (synCtx.getFrom() != null) {
            sb.append(this.separator + "From: " + synCtx.getFrom().getAddress());
        }
        if (synCtx.getWSAAction() != null) {
            sb.append(this.separator + "WSAction: " + synCtx.getWSAAction());
        }
        if (synCtx.getSoapAction() != null) {
            sb.append(this.separator + "SOAPAction: " + synCtx.getSoapAction());
        }
        if (synCtx.getReplyTo() != null) {
            sb.append(this.separator + "ReplyTo: " + synCtx.getReplyTo().getAddress());
        }
        if (synCtx.getMessageID() != null) {
            sb.append(this.separator + "MessageID: " + synCtx.getMessageID());
        }
        sb.append(this.separator + "Direction: " + (synCtx.isResponse() ? "response" : "request"));
        this.setCustomProperties(sb, synCtx);
        return this.trimLeadingSeparator(sb);
    }

    private String getHeadersLogMessage(MessageContext synCtx) {
        SOAPHeader header;
        StringBuffer sb = new StringBuffer();
        if (synCtx.getEnvelope() != null && (header = synCtx.getEnvelope().getHeader()) != null) {
            Iterator iter = header.examineAllHeaderBlocks();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof SOAPHeaderBlock) {
                    SOAPHeaderBlock headerBlk = (SOAPHeaderBlock)o;
                    sb.append(this.separator + headerBlk.getLocalName() + " : " + headerBlk.getText());
                    continue;
                }
                if (!(o instanceof OMElement)) continue;
                OMElement headerElem = (OMElement)o;
                sb.append(this.separator + headerElem.getLocalName() + " : " + headerElem.getText());
            }
        }
        this.setCustomProperties(sb, synCtx);
        return this.trimLeadingSeparator(sb);
    }

    private String getFullLogMessage(MessageContext synCtx) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSimpleLogMessage(synCtx));
        if (synCtx.getEnvelope() != null) {
            sb.append(this.separator + "Envelope: " + synCtx.getEnvelope());
        }
        return this.trimLeadingSeparator(sb);
    }

    private void setCustomProperties(StringBuffer sb, MessageContext synCtx) {
        if (this.properties != null && !this.properties.isEmpty()) {
            for (MediatorProperty prop : this.properties) {
                sb.append(this.separator + prop.getName() + " = " + (prop.getValue() != null ? prop.getValue() : prop.getEvaluatedExpression(synCtx)));
            }
        }
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void addProperty(MediatorProperty p) {
        this.properties.add(p);
    }

    public void addAllProperties(List list) {
        this.properties.addAll(list);
    }

    public List getProperties() {
        return this.properties;
    }

    private String trimLeadingSeparator(StringBuffer sb) {
        String retStr = sb.toString();
        if (retStr.startsWith(this.separator)) {
            return retStr.substring(this.separator.length());
        }
        return retStr;
    }
}

