/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.builtin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.Replicator;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.saaj.util.SAAJUtil;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.FixedByteArrayOutputStream;
import org.apache.synapse.util.MessageHelper;
import org.w3c.dom.Element;
import org.wso2.caching.CacheManager;
import org.wso2.caching.CachedObject;
import org.wso2.caching.CachingConstants;
import org.wso2.caching.CachingException;
import org.wso2.caching.digest.DigestGenerator;

public class CacheMediator
extends AbstractMediator {
    private String id = null;
    private String scope = "per-host";
    private boolean collector = false;
    private DigestGenerator digestGenerator = CachingConstants.DEFAULT_XML_IDENTIFIER;
    private int inMemoryCacheSize = 1000;
    private int diskCacheSize = 0;
    private long timeout = 0L;
    private SequenceMediator onCacheHitSequence = null;
    private String onCacheHitRef = null;
    private int maxMessageSize = 0;
    private String cacheManagerKey = "cacheManager";
    private static final String CACHE_MANAGER_PREFIX = "synapse.cache_manager_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        boolean result;
        boolean traceOrDebugOn;
        boolean traceOn;
        block22: {
            CacheManager cacheManager;
            Object prop;
            ConfigurationContext cfgCtx;
            block21: {
                traceOn = this.isTraceOn(synCtx);
                traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Start : Cache mediator");
                    if (traceOn && trace.isTraceEnabled()) {
                        trace.trace((Object)("Message : " + synCtx.getEnvelope()));
                    }
                }
                FixedByteArrayOutputStream fbaos = null;
                if (this.maxMessageSize > 0) {
                    fbaos = new FixedByteArrayOutputStream(this.maxMessageSize);
                    try {
                        MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope()).serialize((OutputStream)fbaos);
                    }
                    catch (XMLStreamException e) {
                        this.handleException("Error in checking the message size", e, synCtx);
                    }
                    catch (SynapseException syne) {
                        if (!traceOrDebugOn) break block21;
                        this.traceOrDebug(traceOn, "Message size exceeds the upper bound for caching, request will not be cached");
                        return true;
                    }
                }
            }
            if ((cfgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext()) == null) {
                this.handleException("Unable to perform caching,  ConfigurationContext cannot be found", synCtx);
                return false;
            }
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Looking up cache at scope : " + this.scope + " with ID : " + this.cacheManagerKey);
            }
            if ((prop = cfgCtx.getPropertyNonReplicable(this.cacheManagerKey)) != null && prop instanceof CacheManager) {
                cacheManager = (CacheManager)prop;
            } else {
                ConfigurationContext configurationContext = cfgCtx;
                synchronized (configurationContext) {
                    prop = cfgCtx.getPropertyNonReplicable(this.cacheManagerKey);
                    if (prop != null && prop instanceof CacheManager) {
                        cacheManager = (CacheManager)prop;
                    } else {
                        if (traceOrDebugOn) {
                            this.traceOrDebug(traceOn, "Creating/recreating the cache object");
                        }
                        cacheManager = new CacheManager();
                        cfgCtx.setProperty(this.cacheManagerKey, (Object)cacheManager);
                    }
                }
            }
            result = true;
            try {
                if (synCtx.isResponse()) {
                    this.processResponseMessage(synCtx, cfgCtx, traceOrDebugOn, traceOn, cacheManager);
                } else {
                    result = this.processRequestMessage(synCtx, cfgCtx, traceOrDebugOn, traceOn, cacheManager);
                }
            }
            catch (ClusteringFault clusteringFault) {
                if (!traceOrDebugOn) break block22;
                this.traceOrDebug(traceOn, "Unable to replicate Cache mediator state among the cluster");
            }
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "End : Cache mediator");
        }
        return result;
    }

    private void processResponseMessage(MessageContext synCtx, ConfigurationContext cfgCtx, boolean traceOrDebugOn, boolean traceOn, CacheManager cacheManager) throws ClusteringFault {
        String requestHash;
        if (!this.collector) {
            this.handleException("Response messages cannot be handled in a non collector cache", synCtx);
        }
        if ((requestHash = (String)synCtx.getProperty("requestHash")) != null) {
            CachedObject cachedObj;
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Storing the response message into the cache at scope : " + this.scope + " with ID : " + this.cacheManagerKey + " for request hash : " + requestHash);
            }
            if ((cachedObj = cacheManager.getResponseForKey(requestHash, (AbstractContext)cfgCtx)) != null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Storing the response for the message with ID : " + synCtx.getMessageID() + " with request hash ID : " + cachedObj.getRequestHash() + " in the cache : " + this.cacheManagerKey);
                }
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                try {
                    MessageHelper.cloneSOAPEnvelope(synCtx.getEnvelope()).serialize((OutputStream)outStream);
                    cachedObj.setResponseEnvelope(outStream.toByteArray());
                }
                catch (XMLStreamException e) {
                    this.handleException("Unable to set the response to the Cache", e, synCtx);
                }
                if (cachedObj.getTimeout() > 0L) {
                    cachedObj.setExpireTimeMillis(System.currentTimeMillis() + cachedObj.getTimeout());
                }
                cfgCtx.setProperty(this.cacheManagerKey, (Object)cacheManager);
                Replicator.replicate((AbstractContext)cfgCtx);
            } else {
                this.auditWarn("A response message without a valid mapping to the request hash found. Unable to store the response in cache", synCtx);
            }
        } else {
            this.auditWarn("A response message without a mapping to the request hash found. Unable to store the response in cache", synCtx);
        }
    }

    private boolean processRequestMessage(MessageContext synCtx, ConfigurationContext cfgCtx, boolean traceOrDebugOn, boolean traceOn, CacheManager cacheManager) throws ClusteringFault {
        if (this.collector) {
            this.handleException("Request messages cannot be handled in a collector cache", synCtx);
        }
        String requestHash = null;
        try {
            requestHash = this.digestGenerator.getDigest(((Axis2MessageContext)synCtx).getAxis2MessageContext());
            synCtx.setProperty("requestHash", requestHash);
        }
        catch (CachingException e) {
            this.handleException("Error in calculating the hash value of the request", (Exception)((Object)e), synCtx);
        }
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Generated request hash : " + requestHash);
        }
        if (cacheManager.containsKey(requestHash) && cacheManager.getResponseForKey(requestHash, (AbstractContext)cfgCtx) != null) {
            CachedObject cachedObj = cacheManager.getResponseForKey(requestHash, (AbstractContext)cfgCtx);
            if (!cachedObj.isExpired() && cachedObj.getResponseEnvelope() != null) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "Cache-hit for message ID : " + synCtx.getMessageID());
                }
                synCtx.setResponse(true);
                try {
                    MessageFactory mf = MessageFactory.newInstance();
                    SOAPMessage smsg = mf.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(cachedObj.getResponseEnvelope()));
                    SOAPEnvelope omSOAPEnv = SAAJUtil.toOMSOAPEnvelope((Element)smsg.getSOAPPart().getDocumentElement());
                    synCtx.setEnvelope(omSOAPEnv);
                }
                catch (AxisFault axisFault) {
                    this.handleException("Error setting response envelope from cache : " + this.cacheManagerKey, synCtx);
                }
                catch (IOException ioe) {
                    this.handleException("Error setting response envelope from cache : " + this.cacheManagerKey, ioe, synCtx);
                }
                catch (SOAPException soape) {
                    this.handleException("Error setting response envelope from cache : " + this.cacheManagerKey, (Exception)((Object)soape), synCtx);
                }
                if (this.onCacheHitSequence != null) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Delegating message to the onCachingHit Anonymous sequence");
                    }
                    this.onCacheHitSequence.mediate(synCtx);
                } else if (this.onCacheHitRef != null) {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Delegating message to the onCachingHit sequence : " + this.onCacheHitRef);
                    }
                    synCtx.getSequence(this.onCacheHitRef).mediate(synCtx);
                } else {
                    if (traceOrDebugOn) {
                        this.traceOrDebug(traceOn, "Request message " + synCtx.getMessageID() + " was served from the cache : " + this.cacheManagerKey);
                    }
                    synCtx.setTo(null);
                    Axis2Sender.sendBack(synCtx);
                }
                return false;
            }
            cachedObj.expire();
            cachedObj.setTimeout(this.timeout);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Existing cached response has expired. Reset cache element");
            }
            cfgCtx.setProperty(this.cacheManagerKey, (Object)cacheManager);
            Replicator.replicate((AbstractContext)cfgCtx);
        } else if (cacheManager.getCacheKeys().size() == this.inMemoryCacheSize) {
            cacheManager.removeExpiredResponses((AbstractContext)cfgCtx);
            if (cacheManager.getCacheKeys().size() == this.inMemoryCacheSize) {
                if (traceOrDebugOn) {
                    this.traceOrDebug(traceOn, "In-memory cache is full. Unable to cache");
                }
            } else {
                this.storeRequestToCache(cfgCtx, requestHash, cacheManager);
            }
        } else {
            this.storeRequestToCache(cfgCtx, requestHash, cacheManager);
        }
        return true;
    }

    private void storeRequestToCache(ConfigurationContext cfgCtx, String requestHash, CacheManager cacheManager) throws ClusteringFault {
        CachedObject cachedObj = new CachedObject();
        cachedObj.setRequestHash(requestHash);
        cachedObj.setTimeout(this.timeout);
        cacheManager.addResponseWithKey(requestHash, cachedObj, (AbstractContext)cfgCtx);
        cfgCtx.setProperty(this.cacheManagerKey, (Object)cacheManager);
        Replicator.replicate((AbstractContext)cfgCtx);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
        if ("per-mediator".equals(scope)) {
            this.cacheManagerKey = CACHE_MANAGER_PREFIX + this.id;
        }
    }

    public boolean isCollector() {
        return this.collector;
    }

    public void setCollector(boolean collector) {
        this.collector = collector;
    }

    public DigestGenerator getDigestGenerator() {
        return this.digestGenerator;
    }

    public void setDigestGenerator(DigestGenerator digestGenerator) {
        this.digestGenerator = digestGenerator;
    }

    public int getInMemoryCacheSize() {
        return this.inMemoryCacheSize;
    }

    public void setInMemoryCacheSize(int inMemoryCacheSize) {
        this.inMemoryCacheSize = inMemoryCacheSize;
    }

    public int getDiskCacheSize() {
        return this.diskCacheSize;
    }

    public void setDiskCacheSize(int diskCacheSize) {
        this.diskCacheSize = diskCacheSize;
    }

    public long getTimeout() {
        return this.timeout / 1000L;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout * 1000L;
    }

    public SequenceMediator getOnCacheHitSequence() {
        return this.onCacheHitSequence;
    }

    public void setOnCacheHitSequence(SequenceMediator onCacheHitSequence) {
        this.onCacheHitSequence = onCacheHitSequence;
    }

    public String getOnCacheHitRef() {
        return this.onCacheHitRef;
    }

    public void setOnCacheHitRef(String onCacheHitRef) {
        this.onCacheHitRef = onCacheHitRef;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }
}

