/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.base;

import java.util.Stack;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractListMediator;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.statistics.StatisticsStack;
import org.apache.synapse.statistics.StatisticsUtils;
import org.apache.synapse.statistics.impl.SequenceStatisticsStack;

public class SequenceMediator
extends AbstractListMediator {
    private String name = null;
    private String key = null;
    private String errorHandler = null;
    private boolean dynamic = false;
    private boolean initialized = false;
    private String registryKey = null;
    private int statisticsState = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        boolean statsOn = 1 == this.statisticsState;
        boolean traceOn = this.isTraceOn(synCtx);
        boolean traceOrDebugOn = this.isTraceOrDebugOn(traceOn);
        if (traceOrDebugOn) {
            this.traceOrDebug(traceOn, "Start : Sequence " + (this.name == null ? (this.key == null ? "<anonymous" : "key=<" + this.key) : "<" + this.name) + ">");
            if (traceOn && trace.isTraceEnabled()) {
                trace.trace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (this.key == null) {
            Mediator errorHandlerMediator = null;
            if (statsOn) {
                StatisticsStack sequenceStack = (StatisticsStack)synCtx.getProperty("synapse.sequence.stats");
                if (sequenceStack == null) {
                    sequenceStack = new SequenceStatisticsStack();
                    synCtx.setProperty("synapse.sequence.stats", sequenceStack);
                }
                String seqName = this.name == null ? "AnonymousSequence" : this.name;
                boolean isFault = synCtx.getEnvelope().getBody().hasFault();
                sequenceStack.put(seqName, System.currentTimeMillis(), !synCtx.isResponse(), statsOn, isFault);
            }
            try {
                Object o;
                Stack faultStack;
                if (this.errorHandler != null) {
                    errorHandlerMediator = synCtx.getSequence(this.errorHandler);
                    if (errorHandlerMediator != null) {
                        if (traceOrDebugOn) {
                            this.traceOrDebug(traceOn, "Setting the onError handler : " + this.errorHandler + " for the sequence : " + this.name);
                        }
                        synCtx.pushFaultHandler(new MediatorFaultHandler(errorHandlerMediator));
                    } else {
                        this.auditWarn("onError handler : " + this.errorHandler + " for sequence : " + this.name + " cannot be found", synCtx);
                    }
                }
                boolean result = super.mediate(synCtx);
                if (errorHandlerMediator != null && (faultStack = synCtx.getFaultStack()) != null && !faultStack.isEmpty() && (o = faultStack.peek()) instanceof MediatorFaultHandler && errorHandlerMediator.equals(((MediatorFaultHandler)o).getFaultMediator())) {
                    faultStack.pop();
                }
                if (traceOrDebugOn) {
                    if (traceOn && trace.isTraceEnabled()) {
                        trace.trace((Object)("Message : " + synCtx.getEnvelope()));
                    }
                    this.traceOrDebug(traceOn, "End : Sequence <" + (this.name == null ? "anonymous" : this.name) + ">");
                }
                boolean bl = result;
                return bl;
            }
            finally {
                if (statsOn) {
                    StatisticsUtils.processSequenceStatistics(synCtx);
                }
                StatisticsUtils.processProxyServiceStatistics(synCtx);
            }
        }
        Mediator m = synCtx.getSequence(this.key);
        if (m != null) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Executing with key " + this.key);
            }
            boolean result = m.mediate(synCtx);
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "End : Sequence key=<" + this.key + ">");
            }
            return result;
        }
        this.handleException("Sequence named " + this.key + " cannot be found", synCtx);
        return false;
    }

    public synchronized void init(SynapseEnvironment se) {
        if (!this.initialized) {
            super.init(se);
            this.initialized = true;
        }
    }

    public synchronized void destroy() {
        if (this.initialized) {
            super.destroy();
            this.initialized = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public int getStatisticsState() {
        return this.statisticsState;
    }

    public void setStatisticsState(int statisticsState) {
        this.statisticsState = statisticsState;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getRegistryKey() {
        return this.registryKey;
    }

    public void setRegistryKey(String registryKey) {
        this.registryKey = registryKey;
    }
}

