/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.synapse.MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;

public class SoapSessionDispatcher
implements Dispatcher {
    private Map sessionMap = Collections.synchronizedMap(new HashMap());

    public Endpoint getEndpoint(MessageContext synCtx) {
        Object e;
        String sgcID;
        OMElement sgcElm;
        Endpoint endpoint = null;
        SOAPHeader header = synCtx.getEnvelope().getHeader();
        if (header != null && (sgcElm = header.getFirstChildWithName(new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2"))) != null && (sgcID = sgcElm.getText()) != null && (e = this.sessionMap.get(sgcID)) != null) {
            endpoint = (Endpoint)e;
        }
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSession(MessageContext synCtx, Endpoint endpoint) {
        OMElement referenceParameters;
        OMElement replyTo;
        SOAPHeader header = synCtx.getEnvelope().getHeader();
        if (header != null && (replyTo = header.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "ReplyTo", "wsa"))) != null && (referenceParameters = replyTo.getFirstChildWithName(new QName("http://www.w3.org/2005/08/addressing", "ReferenceParameters", "wsa"))) != null) {
            OMElement sgcElm = referenceParameters.getFirstChildWithName(new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2"));
            Map map = this.sessionMap;
            synchronized (map) {
                String sgcID = sgcElm.getText();
                if (!this.sessionMap.containsKey(sgcID)) {
                    this.sessionMap.put(sgcID, endpoint);
                }
            }
        }
    }

    public void unbind(MessageContext synCtx) {
        String sgcID;
        OMElement sgcIDElm;
        SOAPHeader header = synCtx.getEnvelope().getHeader();
        if (header != null && (sgcIDElm = header.getFirstChildWithName(new QName("http://ws.apache.org/namespaces/axis2", "ServiceGroupId", "axis2"))) != null && (sgcID = sgcIDElm.getText()) != null) {
            this.sessionMap.remove(sgcID);
        }
    }

    public boolean isServerInitiatedSession() {
        return true;
    }
}

