/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints.dispatch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.MessageContext;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.dispatch.Dispatcher;

public class HttpSessionDispatcher
implements Dispatcher {
    private static final String TRANSPORT_HEADERS = "TRANSPORT_HEADERS";
    private static final String COOKIE = "Cookie";
    private static final String SET_COOKIE = "Set-Cookie";
    private final Map sessionMap = Collections.synchronizedMap(new HashMap());

    public Endpoint getEndpoint(MessageContext synCtx) {
        Object e;
        Map headerMap;
        Object cookie;
        Endpoint endpoint = null;
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty(TRANSPORT_HEADERS);
        if (o != null && o instanceof Map && (cookie = (headerMap = (Map)o).get(COOKIE)) != null && (e = this.sessionMap.get(cookie)) != null) {
            endpoint = (Endpoint)e;
        }
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSession(MessageContext synCtx, Endpoint endpoint) {
        Map headerMap;
        Object cookie;
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty(TRANSPORT_HEADERS);
        if (o != null && o instanceof Map && (cookie = (headerMap = (Map)o).get(SET_COOKIE)) != null) {
            Map map = this.sessionMap;
            synchronized (map) {
                if (!this.sessionMap.containsKey(cookie)) {
                    this.sessionMap.put(cookie, endpoint);
                }
            }
        }
    }

    public void unbind(MessageContext synCtx) {
        Map headerMap;
        Object cookie;
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Object o = axis2MessageContext.getProperty(TRANSPORT_HEADERS);
        if (o != null && o instanceof Map && (cookie = (headerMap = (Map)o).get(COOKIE)) != null) {
            this.sessionMap.remove(cookie);
        }
    }

    public boolean isServerInitiatedSession() {
        return true;
    }
}

