/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerManager;

public class SynapseStartUpServlet
extends HttpServlet {
    private static Log log = LogFactory.getLog(SynapseStartUpServlet.class);

    public void init() throws ServletException {
        super.init();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ServerManager serverManager = ServerManager.getInstance();
        ServletContext servletContext = servletConfig.getServletContext();
        if ("true".equals(servletContext.getAttribute("hasAlreadyInit"))) {
            return;
        }
        String synapseHome = this.resolveSynapseHome(servletConfig);
        if (synapseHome != null) {
            String synapseXml;
            String axis2Xml;
            if (synapseHome.endsWith("/")) {
                synapseHome = synapseHome.substring(0, synapseHome.lastIndexOf("/"));
            }
            System.setProperty("synapse.home", synapseHome);
            String axis2Repo = System.getProperty("axis2.repo");
            if (axis2Repo == null) {
                ServerManager.getInstance().setAxis2Repolocation(synapseHome + "/WEB-INF" + File.separator + "repository");
                System.setProperty("axis2.repo", synapseHome + "/WEB-INF" + File.separator + "repository");
            }
            if ((axis2Xml = System.getProperty("axis2.xml")) == null) {
                System.setProperty("axis2.xml", synapseHome + File.separator + "WEB-INF/conf" + File.separator + "axis2.xml");
            }
            if ((synapseXml = System.getProperty("synapse.xml")) == null) {
                System.setProperty("synapse.xml", synapseHome + File.separator + "WEB-INF/conf" + File.separator + "synapse.xml");
            }
        } else {
            log.fatal((Object)"Can not resolve synapse home  : startup failed");
            return;
        }
        serverManager.start();
        servletContext.setAttribute("hasAlreadyInit", (Object)"true");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void destroy() {
        try {
            ServerManager serverManager = ServerManager.getInstance();
            serverManager.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String resolveSynapseHome(ServletConfig servletConfig) {
        ServletContext servletContext;
        String webinfPath;
        String synapseHomeAsParam = servletConfig.getInitParameter("synapse.home");
        if (synapseHomeAsParam != null && synapseHomeAsParam.endsWith("/")) {
            return synapseHomeAsParam.substring(0, synapseHomeAsParam.lastIndexOf("/"));
        }
        String synapseHome = System.getProperty("synapse.home");
        if ((synapseHome == null || "".equals(synapseHome)) && (webinfPath = (servletContext = servletConfig.getServletContext()).getRealPath("WEB-INF")) != null && (synapseHome = webinfPath.substring(0, webinfPath.lastIndexOf("WEB-INF"))) != null && synapseHome.endsWith("/")) {
            synapseHome = synapseHome.substring(0, synapseHome.lastIndexOf("/"));
        }
        return synapseHome;
    }
}

