/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.CustomWSDLLocator;
import org.apache.synapse.endpoints.utils.EndpointDefinition;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WSDL11EndpointBuilder {
    private static Log log = LogFactory.getLog(WSDL11EndpointBuilder.class);

    public EndpointDefinition createEndpointDefinitionFromWSDL(String baseUri, OMElement wsdl, String service, String port) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            wsdl.serialize((OutputStream)baos);
            ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
            InputSource inputSource = new InputSource(in);
            CustomWSDLLocator wsdlLocator = new CustomWSDLLocator(inputSource, baseUri);
            Document doc = null;
            try {
                doc = XMLUtils.newDocument((InputSource)inputSource);
            }
            catch (ParserConfigurationException e) {
                WSDL11EndpointBuilder.handleException("Parser Configuration Error", e);
            }
            catch (SAXException e) {
                WSDL11EndpointBuilder.handleException("Parser SAX Error", e);
            }
            catch (IOException e) {
                WSDL11EndpointBuilder.handleException("INVALID_WSDLIO Error", e);
            }
            if (doc != null) {
                WSDLFactory fac = WSDLFactory.newInstance();
                WSDLReader reader = fac.newWSDLReader();
                Definition definition = reader.readWSDL((WSDLLocator)wsdlLocator, doc.getDocumentElement());
                return this.createEndpointDefinitionFromWSDL(definition, service, port);
            }
        }
        catch (XMLStreamException e) {
            WSDL11EndpointBuilder.handleException("Error retrieving the WSDL definition from the inline WSDL.");
        }
        catch (WSDLException e) {
            WSDL11EndpointBuilder.handleException("Error retrieving the WSDL definition from the inline WSDL.");
        }
        return null;
    }

    private EndpointDefinition createEndpointDefinitionFromWSDL(String wsdlURI, String service, String port) {
        try {
            WSDLFactory fac = WSDLFactory.newInstance();
            WSDLReader reader = fac.newWSDLReader();
            Definition definition = reader.readWSDL(wsdlURI);
            return this.createEndpointDefinitionFromWSDL(definition, service, port);
        }
        catch (WSDLException e) {
            WSDL11EndpointBuilder.handleException("Error retrieving the WSDL definition from the WSDL URI.");
            return null;
        }
    }

    private EndpointDefinition createEndpointDefinitionFromWSDL(Definition definition, String serviceName, String portName) {
        Port port;
        if (definition == null) {
            WSDL11EndpointBuilder.handleException("WSDL is not specified.");
        }
        if (serviceName == null) {
            WSDL11EndpointBuilder.handleException("Service of the WSDL document is not specified.");
        }
        if (portName == null) {
            WSDL11EndpointBuilder.handleException("Port of the WSDL document is not specified.");
        }
        String serviceURL = null;
        String format = null;
        String tns = definition.getTargetNamespace();
        Service service = definition.getService(new QName(tns, serviceName));
        if (service != null && (port = service.getPort(portName)) != null) {
            List ext = port.getExtensibilityElements();
            for (int i = 0; i < ext.size(); ++i) {
                Object o = ext.get(i);
                if (o instanceof SOAPAddress) {
                    SOAPAddress address = (SOAPAddress)o;
                    serviceURL = address.getLocationURI();
                    format = "soap11";
                    break;
                }
                if (!(o instanceof SOAP12Address)) continue;
                SOAP12Address address = (SOAP12Address)o;
                serviceURL = address.getLocationURI();
                format = "soap12";
                break;
            }
        }
        if (serviceURL != null) {
            EndpointDefinition endpointDefinition = new EndpointDefinition();
            endpointDefinition.setAddress(serviceURL);
            endpointDefinition.setFormat(format);
            return endpointDefinition;
        }
        WSDL11EndpointBuilder.handleException("Couldn't retrieve endpoint information from the WSDL.");
        return null;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

