/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class WSDLEndpointSerializer
implements EndpointSerializer {
    private static Log log = LogFactory.getLog(WSDLEndpointSerializer.class);
    private OMFactory fac = null;

    public OMElement serializeEndpoint(Endpoint endpoint) {
        long suspendDuration;
        OMElement wsdlDoc;
        String uri;
        String portName;
        if (!(endpoint instanceof WSDLEndpoint)) {
            throw new SynapseException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        WSDLEndpoint wsdlEndpoint = (WSDLEndpoint)endpoint;
        String name = wsdlEndpoint.getName();
        if (name != null) {
            endpointElement.addAttribute("name", name, null);
        }
        OMElement wsdlElement = this.fac.createOMElement("wsdl", SynapseConstants.SYNAPSE_OMNAMESPACE);
        String serviceName = wsdlEndpoint.getServiceName();
        if (serviceName != null) {
            wsdlElement.addAttribute("service", serviceName, null);
        }
        if ((portName = wsdlEndpoint.getPortName()) != null) {
            wsdlElement.addAttribute("port", portName, null);
        }
        if ((uri = wsdlEndpoint.getWsdlURI()) != null) {
            wsdlElement.addAttribute("uri", uri, null);
        }
        if ((wsdlDoc = wsdlEndpoint.getWsdlDoc()) != null) {
            wsdlElement.addChild((OMNode)wsdlDoc);
        }
        if ((suspendDuration = wsdlEndpoint.getSuspendOnFailDuration()) != -1L) {
            OMElement suspendElement = this.fac.createOMElement("suspendDurationOnFailure", SynapseConstants.SYNAPSE_OMNAMESPACE);
            suspendElement.setText(Long.toString(suspendDuration / 1000L));
            wsdlElement.addChild((OMNode)suspendElement);
        }
        EndpointDefinition epAddress = wsdlEndpoint.getEndpoint();
        this.serializeQOSInformation(epAddress, wsdlElement);
        endpointElement.addChild((OMNode)wsdlElement);
        return endpointElement;
    }

    public void serializeQOSInformation(EndpointDefinition endpointDefinition, OMElement wsdlElement) {
        if ("pox".equals(endpointDefinition.getFormat())) {
            wsdlElement.addAttribute(this.fac.createOMAttribute("format", null, "pox"));
        } else if ("get".equals(endpointDefinition.getFormat())) {
            wsdlElement.addAttribute(this.fac.createOMAttribute("format", null, "get"));
        } else if ("soap11".equals(endpointDefinition.getFormat())) {
            wsdlElement.addAttribute(this.fac.createOMAttribute("format", null, "soap11"));
        } else if ("soap12".equals(endpointDefinition.getFormat())) {
            wsdlElement.addAttribute(this.fac.createOMAttribute("format", null, "soap12"));
        } else if (endpointDefinition.isForcePOX()) {
            wsdlElement.addAttribute(this.fac.createOMAttribute("format", null, "pox"));
        } else if (endpointDefinition.isForceGET()) {
            wsdlElement.addAttribute(this.fac.createOMAttribute("format", null, "get"));
        } else if (endpointDefinition.isForceSOAP11()) {
            wsdlElement.addAttribute(this.fac.createOMAttribute("format", null, "soap11"));
        } else if (endpointDefinition.isForceSOAP12()) {
            wsdlElement.addAttribute(this.fac.createOMAttribute("format", null, "soap12"));
        }
        int isEnableStatistics = endpointDefinition.getStatisticsState();
        String statisticsValue = null;
        if (isEnableStatistics == 1) {
            statisticsValue = "enable";
        } else if (isEnableStatistics == 0) {
            statisticsValue = "disable";
        }
        if (statisticsValue != null) {
            wsdlElement.addAttribute(this.fac.createOMAttribute("statistics", null, statisticsValue));
        }
        if (endpointDefinition.isAddressingOn()) {
            OMElement addressing = this.fac.createOMElement("enableAddressing", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.isUseSeparateListener()) {
                addressing.addAttribute(this.fac.createOMAttribute("separateListener", null, "true"));
            }
            wsdlElement.addChild((OMNode)addressing);
        }
        if (endpointDefinition.isReliableMessagingOn()) {
            OMElement rm = this.fac.createOMElement("enableRM", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getWsRMPolicyKey() != null) {
                rm.addAttribute(this.fac.createOMAttribute("policy", null, endpointDefinition.getWsRMPolicyKey()));
            }
            wsdlElement.addChild((OMNode)rm);
        }
        if (endpointDefinition.isSecurityOn()) {
            OMElement sec = this.fac.createOMElement("enableSec", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getWsSecPolicyKey() != null) {
                sec.addAttribute(this.fac.createOMAttribute("policy", null, endpointDefinition.getWsSecPolicyKey()));
            }
            wsdlElement.addChild((OMNode)sec);
        }
        if (endpointDefinition.getTimeoutAction() != 100) {
            OMElement timeout = this.fac.createOMElement("timeout", SynapseConstants.SYNAPSE_OMNAMESPACE);
            wsdlElement.addChild((OMNode)timeout);
            OMElement duration = this.fac.createOMElement("duration", SynapseConstants.SYNAPSE_OMNAMESPACE);
            duration.setText(Long.toString(endpointDefinition.getTimeoutDuration() / 1000L));
            timeout.addChild((OMNode)duration);
            OMElement action = this.fac.createOMElement("action", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpointDefinition.getTimeoutAction() == 101) {
                action.setText("discard");
            } else if (endpointDefinition.getTimeoutAction() == 102) {
                action.setText("fault");
            }
            timeout.addChild((OMNode)action);
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

