/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import java.io.File;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.config.xml.endpoints.utils.WSDL11EndpointBuilder;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.WSDLEndpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class WSDLEndpointFactory
implements EndpointFactory {
    private static Log log = LogFactory.getLog(WSDLEndpointFactory.class);
    private static WSDLEndpointFactory instance = new WSDLEndpointFactory();

    private WSDLEndpointFactory() {
    }

    public static WSDLEndpointFactory getInstance() {
        return instance;
    }

    public Object getObjectFromOMNode(OMNode om) {
        if (om instanceof OMElement) {
            return this.createEndpoint((OMElement)om, false);
        }
        WSDLEndpointFactory.handleException("Invalid XML configuration for an Endpoint. OMElement expected");
        return null;
    }

    public Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint) {
        OMElement wsdlElement;
        OMAttribute name;
        WSDLEndpoint wsdlEndpoint = new WSDLEndpoint();
        if (!anonymousEndpoint && (name = epConfig.getAttribute(new QName("", "name"))) != null) {
            wsdlEndpoint.setName(name.getAttributeValue());
        }
        if ((wsdlElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "wsdl"))) != null) {
            OMElement suspendElement = wsdlElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "suspendDurationOnFailure"));
            if (suspendElement != null) {
                String suspend = suspendElement.getText();
                try {
                    if (suspend != null) {
                        long suspendDuration = Long.parseLong(suspend.trim());
                        wsdlEndpoint.setSuspendOnFailDuration(suspendDuration * 1000L);
                    }
                }
                catch (NumberFormatException e) {
                    WSDLEndpointFactory.handleException("suspendDurationOnFailure should be valid number.");
                }
            }
            EndpointDefinition endpoint = null;
            String serviceName = wsdlElement.getAttributeValue(new QName("", "service"));
            String portName = wsdlElement.getAttributeValue(new QName("", "port"));
            String wsdlURI = wsdlElement.getAttributeValue(new QName("", "uri"));
            wsdlEndpoint.setServiceName(serviceName);
            wsdlEndpoint.setPortName(portName);
            if (wsdlURI != null) {
                wsdlEndpoint.setWsdlURI(wsdlURI.trim());
                try {
                    OMNamespace ns;
                    OMElement wsdlOM = SynapseConfigUtils.getOMElementFromURL(new URL(wsdlURI).toString());
                    if (wsdlOM != null && (ns = wsdlOM.getNamespace()) != null) {
                        String nsUri = wsdlOM.getNamespace().getNamespaceURI();
                        if ("http://schemas.xmlsoap.org/wsdl/".equals(nsUri)) {
                            endpoint = new WSDL11EndpointBuilder().createEndpointDefinitionFromWSDL(wsdlURI.trim(), wsdlOM, serviceName, portName);
                        } else if ("http://www.w3.org/ns/wsdl".equals(nsUri)) {
                            WSDLEndpointFactory.handleException("WSDL 2.0 Endpoints are currently not supported");
                        }
                    }
                }
                catch (Exception e) {
                    WSDLEndpointFactory.handleException("Couldn't create endpoint from the given WSDL URI : " + e.getMessage(), e);
                }
            }
            OMElement definitionElement = wsdlElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/wsdl/", "definitions"));
            if (endpoint == null && definitionElement != null) {
                wsdlEndpoint.setWsdlDoc(definitionElement);
                String resolveRoot = System.getProperty("resolve.root");
                String baseUri = "file:./";
                if (resolveRoot != null) {
                    baseUri = resolveRoot.trim();
                }
                if (!baseUri.endsWith(File.separator)) {
                    baseUri = baseUri + File.separator;
                }
                endpoint = new WSDL11EndpointBuilder().createEndpointDefinitionFromWSDL(baseUri, definitionElement, serviceName, portName);
            }
            OMElement descriptionElement = wsdlElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/wsdl/", "description"));
            if (endpoint == null && descriptionElement != null) {
                wsdlEndpoint.setWsdlDoc(descriptionElement);
                WSDLEndpointFactory.handleException("WSDL 2.0 Endpoints are currently not supported.");
            }
            if (endpoint != null) {
                String statisticsValue;
                this.extractQOSInformation(endpoint, wsdlElement);
                OMAttribute statistics = epConfig.getAttribute(new QName("", "statistics"));
                if (statistics != null && (statisticsValue = statistics.getAttributeValue()) != null) {
                    if ("enable".equals(statisticsValue)) {
                        endpoint.setStatisticsState(1);
                    } else if ("disable".equals(statisticsValue)) {
                        endpoint.setStatisticsState(0);
                    }
                }
                wsdlEndpoint.setEndpoint(endpoint);
            } else {
                WSDLEndpointFactory.handleException("WSDL is not specified for WSDL endpoint.");
            }
        }
        return wsdlEndpoint;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    private void extractQOSInformation(EndpointDefinition endpointDefinition, OMElement wsdlElement) {
        OMElement timeout;
        OMElement wsRm;
        OMElement wsSec;
        OMElement wsAddr;
        OMAttribute format = wsdlElement.getAttribute(new QName("", "format"));
        OMAttribute optimize = wsdlElement.getAttribute(new QName("", "optimize"));
        if (format != null) {
            String forceValue = format.getAttributeValue().trim().toLowerCase();
            if ("pox".equals(forceValue)) {
                endpointDefinition.setForcePOX(true);
                endpointDefinition.setFormat("pox");
            } else if ("get".equals(forceValue)) {
                endpointDefinition.setForceGET(true);
                endpointDefinition.setFormat("get");
            } else if ("soap11".equals(forceValue)) {
                endpointDefinition.setForceSOAP11(true);
                endpointDefinition.setFormat("soap11");
            } else if ("soap12".equals(forceValue)) {
                endpointDefinition.setForceSOAP12(true);
                endpointDefinition.setFormat("soap12");
            } else {
                WSDLEndpointFactory.handleException("force value -\"" + forceValue + "\" not yet implemented");
            }
        }
        if (optimize != null && optimize.getAttributeValue().length() > 0) {
            String method = optimize.getAttributeValue().trim();
            if ("mtom".equalsIgnoreCase(method)) {
                endpointDefinition.setUseMTOM(true);
            } else if ("swa".equalsIgnoreCase(method)) {
                endpointDefinition.setUseSwa(true);
            }
        }
        if ((wsAddr = wsdlElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableAddressing"))) != null) {
            endpointDefinition.setAddressingOn(true);
            String useSepList = wsAddr.getAttributeValue(new QName("separateListener"));
            if (useSepList != null && (useSepList.trim().toLowerCase().startsWith("tr") || useSepList.trim().startsWith("1"))) {
                endpointDefinition.setUseSeparateListener(true);
            }
        }
        if ((wsSec = wsdlElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableSec"))) != null) {
            endpointDefinition.setSecurityOn(true);
            OMAttribute policy = wsSec.getAttribute(new QName("", "policy"));
            if (policy != null) {
                endpointDefinition.setWsSecPolicyKey(policy.getAttributeValue());
            }
        }
        if ((wsRm = wsdlElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableRM"))) != null) {
            endpointDefinition.setReliableMessagingOn(true);
            OMAttribute policy = wsRm.getAttribute(new QName("", "policy"));
            if (policy != null) {
                endpointDefinition.setWsRMPolicyKey(policy.getAttributeValue());
            }
        }
        if ((timeout = wsdlElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "timeout"))) != null) {
            String a;
            OMElement action;
            String d;
            OMElement duration = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "duration"));
            if (duration != null && (d = duration.getText()) != null) {
                long timeoutSeconds = new Long(d.trim());
                endpointDefinition.setTimeoutDuration(timeoutSeconds * 1000L);
            }
            if ((action = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "action"))) != null && (a = action.getText()) != null) {
                if (a.trim().equalsIgnoreCase("discard")) {
                    endpointDefinition.setTimeoutAction(101);
                    if (endpointDefinition.getTimeoutDuration() == 0L) {
                        endpointDefinition.setTimeoutDuration(30000L);
                    }
                } else if (a.trim().equalsIgnoreCase("fault")) {
                    endpointDefinition.setTimeoutAction(102);
                    if (endpointDefinition.getTimeoutDuration() == 0L) {
                        endpointDefinition.setTimeoutDuration(30000L);
                    }
                }
            }
        }
    }
}

