/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.EndpointSerializer;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class AddressEndpointSerializer
implements EndpointSerializer {
    private static Log log = LogFactory.getLog(AddressEndpointSerializer.class);
    private OMFactory fac = null;

    public OMElement serializeEndpoint(Endpoint endpoint) {
        if (!(endpoint instanceof AddressEndpoint)) {
            throw new SynapseException("Invalid endpoint type.");
        }
        this.fac = OMAbstractFactory.getOMFactory();
        OMElement endpointElement = this.fac.createOMElement("endpoint", SynapseConstants.SYNAPSE_OMNAMESPACE);
        AddressEndpoint addressEndpoint = (AddressEndpoint)endpoint;
        String name = addressEndpoint.getName();
        if (name != null) {
            endpointElement.addAttribute("name", name, null);
        }
        EndpointDefinition epAddress = addressEndpoint.getEndpoint();
        OMElement addressElement = this.serializeEndpointDefinition(epAddress);
        endpointElement.addChild((OMNode)addressElement);
        long suspendDuration = addressEndpoint.getSuspendOnFailDuration();
        if (suspendDuration != -1L) {
            OMElement suspendElement = this.fac.createOMElement("suspendDurationOnFailure", SynapseConstants.SYNAPSE_OMNAMESPACE);
            suspendElement.setText(Long.toString(suspendDuration / 1000L));
            addressElement.addChild((OMNode)suspendElement);
        }
        return endpointElement;
    }

    public OMElement serializeEndpointDefinition(EndpointDefinition endpt) {
        OMElement address = this.fac.createOMElement("address", SynapseConstants.SYNAPSE_OMNAMESPACE);
        if ("pox".equals(endpt.getFormat())) {
            address.addAttribute(this.fac.createOMAttribute("format", null, "pox"));
        } else if ("get".equals(endpt.getFormat())) {
            address.addAttribute(this.fac.createOMAttribute("format", null, "get"));
        } else if ("soap11".equals(endpt.getFormat())) {
            address.addAttribute(this.fac.createOMAttribute("format", null, "soap11"));
        } else if ("soap12".equals(endpt.getFormat())) {
            address.addAttribute(this.fac.createOMAttribute("format", null, "soap12"));
        } else if (endpt.isForcePOX()) {
            address.addAttribute(this.fac.createOMAttribute("format", null, "get"));
        } else if (endpt.isForceGET()) {
            address.addAttribute(this.fac.createOMAttribute("format", null, "pox"));
        } else if (endpt.isForceSOAP11()) {
            address.addAttribute(this.fac.createOMAttribute("format", null, "soap11"));
        } else if (endpt.isForceSOAP12()) {
            address.addAttribute(this.fac.createOMAttribute("format", null, "soap12"));
        }
        if (endpt.isUseSwa()) {
            address.addAttribute(this.fac.createOMAttribute("optimize", null, "swa"));
        } else if (endpt.isUseMTOM()) {
            address.addAttribute(this.fac.createOMAttribute("optimize", null, "mtom"));
        }
        if (endpt.getAddress() != null) {
            address.addAttribute(this.fac.createOMAttribute("uri", null, endpt.getAddress()));
        }
        int isEnableStatistics = endpt.getStatisticsState();
        String statisticsValue = null;
        if (isEnableStatistics == 1) {
            statisticsValue = "enable";
        } else if (isEnableStatistics == 0) {
            statisticsValue = "disable";
        }
        if (statisticsValue != null) {
            address.addAttribute(this.fac.createOMAttribute("statistics", null, statisticsValue));
        }
        if (endpt.isAddressingOn()) {
            OMElement addressing = this.fac.createOMElement("enableAddressing", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpt.isUseSeparateListener()) {
                addressing.addAttribute(this.fac.createOMAttribute("separateListener", null, "true"));
            }
            address.addChild((OMNode)addressing);
        }
        if (endpt.isReliableMessagingOn()) {
            OMElement rm = this.fac.createOMElement("enableRM", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpt.getWsRMPolicyKey() != null) {
                rm.addAttribute(this.fac.createOMAttribute("policy", null, endpt.getWsRMPolicyKey()));
            }
            address.addChild((OMNode)rm);
        }
        if (endpt.isSecurityOn()) {
            OMElement sec = this.fac.createOMElement("enableSec", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpt.getWsSecPolicyKey() != null) {
                sec.addAttribute(this.fac.createOMAttribute("policy", null, endpt.getWsSecPolicyKey()));
            }
            address.addChild((OMNode)sec);
        }
        if (endpt.getTimeoutAction() != 100) {
            OMElement timeout = this.fac.createOMElement("timeout", SynapseConstants.SYNAPSE_OMNAMESPACE);
            address.addChild((OMNode)timeout);
            OMElement duration = this.fac.createOMElement("duration", SynapseConstants.SYNAPSE_OMNAMESPACE);
            duration.setText(Long.toString(endpt.getTimeoutDuration() / 1000L));
            timeout.addChild((OMNode)duration);
            OMElement action = this.fac.createOMElement("action", SynapseConstants.SYNAPSE_OMNAMESPACE);
            if (endpt.getTimeoutAction() == 101) {
                action.setText("discard");
            } else if (endpt.getTimeoutAction() == 102) {
                action.setText("fault");
            }
            timeout.addChild((OMNode)action);
        }
        return address;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

