/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml.endpoints;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.endpoints.AddressEndpoint;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.utils.EndpointDefinition;

public class AddressEndpointFactory
implements EndpointFactory {
    private static Log log = LogFactory.getLog(AddressEndpointFactory.class);
    private static AddressEndpointFactory instance = new AddressEndpointFactory();
    private int statisticsState = 2;
    protected int traceState = 2;

    private AddressEndpointFactory() {
    }

    public static AddressEndpointFactory getInstance() {
        return instance;
    }

    public Endpoint createEndpoint(OMElement epConfig, boolean anonymousEndpoint) {
        OMElement addressElement;
        OMAttribute name;
        AddressEndpoint addressEndpoint = new AddressEndpoint();
        if (!anonymousEndpoint && (name = epConfig.getAttribute(new QName("", "name"))) != null) {
            addressEndpoint.setName(name.getAttributeValue());
        }
        if ((addressElement = epConfig.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "address"))) != null) {
            EndpointDefinition endpoint = this.createEndpointDefinition(addressElement);
            addressEndpoint.setEndpoint(endpoint);
            OMElement suspendElement = addressElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "suspendDurationOnFailure"));
            if (suspendElement != null) {
                String suspend = suspendElement.getText();
                try {
                    if (suspend != null) {
                        long suspendDuration = Long.parseLong(suspend.trim());
                        addressEndpoint.setSuspendOnFailDuration(suspendDuration * 1000L);
                    }
                }
                catch (NumberFormatException e) {
                    AddressEndpointFactory.handleException("The suspend duration should be specified as a valid number :: " + e.getMessage(), e);
                }
            }
        }
        return addressEndpoint;
    }

    public Object getObjectFromOMNode(OMNode om) {
        if (om instanceof OMElement) {
            return this.createEndpoint((OMElement)om, false);
        }
        AddressEndpointFactory.handleException("Invalid XML configuration for an Endpoint. OMElement expected");
        return null;
    }

    public EndpointDefinition createEndpointDefinition(OMElement elem) {
        OMElement timeout;
        OMElement wsRm;
        OMElement wsSec;
        OMElement wsAddr;
        String statisticsValue;
        OMAttribute address = elem.getAttribute(new QName("", "uri"));
        OMAttribute format = elem.getAttribute(new QName("", "format"));
        OMAttribute optimize = elem.getAttribute(new QName("", "optimize"));
        EndpointDefinition endpoint = new EndpointDefinition();
        OMAttribute statistics = elem.getAttribute(new QName("", "statistics"));
        if (statistics != null && (statisticsValue = statistics.getAttributeValue()) != null) {
            if ("enable".equals(statisticsValue)) {
                endpoint.setStatisticsState(1);
            } else if ("disable".equals(statisticsValue)) {
                endpoint.setStatisticsState(0);
            }
        }
        if (address != null) {
            endpoint.setAddress(address.getAttributeValue());
        }
        if (format != null) {
            String forceValue = format.getAttributeValue().trim().toLowerCase();
            if ("pox".equals(forceValue)) {
                endpoint.setForcePOX(true);
                endpoint.setFormat("pox");
            } else if ("get".equals(forceValue)) {
                endpoint.setForceGET(true);
                endpoint.setFormat("get");
            } else if ("soap11".equals(forceValue)) {
                endpoint.setForceSOAP11(true);
                endpoint.setFormat("soap11");
            } else if ("soap12".equals(forceValue)) {
                endpoint.setForceSOAP12(true);
                endpoint.setFormat("soap12");
            } else {
                AddressEndpointFactory.handleException("unknown value -\"" + forceValue + "\". Attribute 'format' accepts only 'pox', 'get', 'soap11', 'soap12'");
            }
        }
        if (optimize != null && optimize.getAttributeValue().length() > 0) {
            String method = optimize.getAttributeValue().trim();
            if ("mtom".equalsIgnoreCase(method)) {
                endpoint.setUseMTOM(true);
            } else if ("swa".equalsIgnoreCase(method)) {
                endpoint.setUseSwa(true);
            }
        }
        if ((wsAddr = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableAddressing"))) != null) {
            endpoint.setAddressingOn(true);
            String useSepList = wsAddr.getAttributeValue(new QName("separateListener"));
            if (useSepList != null && (useSepList.trim().toLowerCase().startsWith("tr") || useSepList.trim().startsWith("1"))) {
                endpoint.setUseSeparateListener(true);
            }
        }
        if ((wsSec = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableSec"))) != null) {
            endpoint.setSecurityOn(true);
            OMAttribute policy = wsSec.getAttribute(new QName("", "policy"));
            if (policy != null) {
                endpoint.setWsSecPolicyKey(policy.getAttributeValue());
            }
        }
        if ((wsRm = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "enableRM"))) != null) {
            endpoint.setReliableMessagingOn(true);
            OMAttribute policy = wsRm.getAttribute(new QName("", "policy"));
            if (policy != null) {
                endpoint.setWsRMPolicyKey(policy.getAttributeValue());
            }
        }
        if ((timeout = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "timeout"))) != null) {
            String a;
            OMElement action;
            String d;
            OMElement duration = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "duration"));
            if (duration != null && (d = duration.getText()) != null) {
                try {
                    long timeoutSeconds = new Long(d.trim());
                    endpoint.setTimeoutDuration(timeoutSeconds * 1000L);
                }
                catch (NumberFormatException e) {
                    AddressEndpointFactory.handleException("The timeout seconds should be specified as a valid number :: " + e.getMessage(), e);
                }
            }
            if ((action = timeout.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "action"))) != null && (a = action.getText()) != null) {
                if (a.trim().equalsIgnoreCase("discard")) {
                    endpoint.setTimeoutAction(101);
                    if (endpoint.getTimeoutDuration() == 0L) {
                        endpoint.setTimeoutDuration(30000L);
                    }
                } else if (a.trim().equalsIgnoreCase("fault")) {
                    endpoint.setTimeoutAction(102);
                    if (endpoint.getTimeoutDuration() == 0L) {
                        endpoint.setTimeoutDuration(30000L);
                    }
                }
            }
        }
        return endpoint;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }
}

