/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.List;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorSerializer;
import org.apache.synapse.config.xml.MediatorSerializer;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.builtin.ValidateMediator;

public class ValidateMediatorSerializer
extends AbstractListMediatorSerializer
implements MediatorSerializer {
    public OMElement serializeMediator(OMElement parent, Mediator m) {
        if (!(m instanceof ValidateMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + m.getType());
        }
        ValidateMediator mediator = (ValidateMediator)m;
        OMElement validate = fac.createOMElement("validate", synNS);
        ValidateMediatorSerializer.saveTracingState(validate, mediator);
        if (mediator.getSource() != null) {
            validate.addAttribute(fac.createOMAttribute("source", nullNS, mediator.getSource().toString()));
            this.serializeNamespaces(validate, mediator.getSource());
        }
        for (String key : mediator.getSchemaKeys()) {
            OMElement schema = fac.createOMElement("schema", synNS, (OMContainer)validate);
            schema.addAttribute(fac.createOMAttribute("key", nullNS, key));
        }
        List features = mediator.getFeatures();
        if (!features.isEmpty()) {
            for (MediatorProperty mp : features) {
                OMElement feature = fac.createOMElement("feature", synNS, (OMContainer)validate);
                if (mp.getName() != null) {
                    feature.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
                } else {
                    this.handleException("The Feature name is missing");
                }
                if (mp.getValue() != null) {
                    feature.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
                    continue;
                }
                this.handleException("The Feature value is missing");
            }
        }
        OMElement onFail = fac.createOMElement("on-fail", synNS, (OMContainer)validate);
        this.serializeChildren(onFail, mediator.getList());
        if (parent != null) {
            parent.addChild((OMNode)validate);
        }
        return validate;
    }

    public String getMediatorClassName() {
        return ValidateMediator.class.getName();
    }
}

