/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractListMediatorFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.mediators.builtin.ValidateMediator;
import org.jaxen.JaxenException;
import org.xml.sax.SAXException;

public class ValidateMediatorFactory
extends AbstractListMediatorFactory {
    private static final QName VALIDATE_Q = new QName("http://ws.apache.org/ns/synapse", "validate");
    private static final QName ON_FAIL_Q = new QName("http://ws.apache.org/ns/synapse", "on-fail");
    private static final QName SCHEMA_Q = new QName("http://ws.apache.org/ns/synapse", "schema");

    public Mediator createMediator(OMElement elem) {
        ValidateMediator validateMediator = new ValidateMediator();
        ArrayList<String> schemaKeys = new ArrayList<String>();
        Iterator schemas = elem.getChildrenWithName(SCHEMA_Q);
        while (schemas.hasNext()) {
            Object o = schemas.next();
            if (o instanceof OMElement) {
                OMElement omElem = (OMElement)o;
                OMAttribute keyAtt = omElem.getAttribute(ATT_KEY);
                if (keyAtt != null) {
                    schemaKeys.add(keyAtt.getAttributeValue());
                    continue;
                }
                this.handleException("A 'schema' definition must contain a local property 'key'");
                continue;
            }
            this.handleException("Invalid 'schema' declaration for validate mediator");
        }
        if (schemaKeys.size() == 0) {
            this.handleException("No schemas specified for the validate mediator");
        } else {
            validateMediator.setSchemaKeys(schemaKeys);
        }
        OMAttribute attSource = elem.getAttribute(ATT_SOURCE);
        if (attSource != null) {
            try {
                AXIOMXPath xp = new AXIOMXPath(attSource.getAttributeValue());
                validateMediator.setSource(xp);
                OMElementUtils.addNameSpaces(xp, elem, log);
            }
            catch (JaxenException e) {
                this.handleException("Invalid XPath expression specified for attribute 'source'", (Exception)((Object)e));
            }
        }
        OMElement onFail = null;
        Iterator iterator = elem.getChildrenWithName(ON_FAIL_Q);
        if (iterator.hasNext()) {
            onFail = (OMElement)iterator.next();
        }
        if (onFail != null && onFail.getChildElements().hasNext()) {
            ValidateMediatorFactory.addChildren(onFail, validateMediator);
        } else {
            this.handleException("A non-empty <on-fail> child element is required for the <validate> mediator");
        }
        this.processTraceState(validateMediator, elem);
        Iterator iter = elem.getChildrenWithName(FEATURE_Q);
        while (iter.hasNext()) {
            OMElement featureElem = (OMElement)iter.next();
            OMAttribute attName = featureElem.getAttribute(ATT_NAME);
            OMAttribute attValue = featureElem.getAttribute(ATT_VALUE);
            if (attName != null && attValue != null) {
                String name = attName.getAttributeValue();
                String value = attValue.getAttributeValue();
                if (name != null && value != null) {
                    try {
                        if ("true".equals(value.trim())) {
                            validateMediator.addFeature(name.trim(), true);
                            continue;
                        }
                        if ("false".equals(value.trim())) {
                            validateMediator.addFeature(name.trim(), false);
                            continue;
                        }
                        this.handleException("The feature must have value true or false");
                    }
                    catch (SAXException e) {
                        this.handleException("Error setting validation feature : " + name + " to : " + value, e);
                    }
                    continue;
                }
                this.handleException("The valid values for both of the name and value are need");
                continue;
            }
            this.handleException("Both of the name and value attribute are required for a feature");
        }
        return validateMediator;
    }

    public QName getTagQName() {
        return VALIDATE_Q;
    }
}

