/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.config.xml.endpoints.EndpointAbstractFactory;
import org.apache.synapse.mediators.eip.Target;

public class TargetFactory {
    private static final Log log = LogFactory.getLog(TargetFactory.class);
    private static final QName TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");

    public static Target createTarget(OMElement elem) {
        OMElement endpoint;
        OMElement sequence;
        OMAttribute endpointAttr;
        OMAttribute sequenceAttr;
        OMAttribute soapAction;
        if (!TARGET_Q.equals(elem.getQName())) {
            TargetFactory.handleException("Element does not match with the target QName");
        }
        Target target = new Target();
        OMAttribute toAttr = elem.getAttribute(new QName("", "to"));
        if (toAttr != null && toAttr.getAttributeValue() != null) {
            target.setToAddress(toAttr.getAttributeValue());
        }
        if ((soapAction = elem.getAttribute(new QName("", "soapAction"))) != null && soapAction.getAttributeValue() != null) {
            target.setSoapAction(soapAction.getAttributeValue());
        }
        if ((sequenceAttr = elem.getAttribute(new QName("", "sequence"))) != null && sequenceAttr.getAttributeValue() != null) {
            target.setSequenceRef(sequenceAttr.getAttributeValue());
        }
        if ((endpointAttr = elem.getAttribute(new QName("", "endpoint"))) != null && endpointAttr.getAttributeValue() != null) {
            target.setEndpointRef(endpointAttr.getAttributeValue());
        }
        if ((sequence = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "sequence"))) != null) {
            SequenceMediatorFactory fac = new SequenceMediatorFactory();
            target.setSequence(fac.createAnonymousSequence(sequence));
        }
        if ((endpoint = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "endpoint"))) != null) {
            target.setEndpoint(EndpointAbstractFactory.getEndpointFactroy(endpoint).createEndpoint(endpoint, true));
        }
        return target;
    }

    private static void handleException(String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
        throw new SynapseException(message);
    }
}

