/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.ConfigurationSerializer;
import org.apache.synapse.config.xml.EntrySerializer;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.apache.synapse.config.xml.ProxyServiceSerializer;
import org.apache.synapse.config.xml.RegistrySerializer;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.XMLConfigurationSerializer;
import org.apache.synapse.config.xml.endpoints.EndpointAbstractSerializer;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;

public class SynapseXMLConfigurationSerializer
implements ConfigurationSerializer {
    private static final Log log = LogFactory.getLog(XMLConfigurationSerializer.class);
    private static final OMFactory fac = OMAbstractFactory.getOMFactory();
    private static final OMNamespace synNS = fac.createOMNamespace("http://ws.apache.org/ns/synapse", "syn");
    private static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public OMElement serializeConfiguration(SynapseConfiguration synCfg) {
        OMElement definitions = fac.createOMElement("definitions", synNS);
        if (synCfg.getRegistry() != null) {
            RegistrySerializer.serializeRegistry(definitions, synCfg.getRegistry());
        }
        for (ProxyService service : synCfg.getProxyServices()) {
            ProxyServiceSerializer.serializeProxy(definitions, service);
        }
        HashMap entries = new HashMap();
        HashMap endpoints = new HashMap();
        HashMap sequences = new HashMap();
        for (Object key : synCfg.getLocalRegistry().keySet()) {
            Object o = synCfg.getLocalRegistry().get(key);
            if (o instanceof Mediator) {
                sequences.put(key, o);
                continue;
            }
            if (o instanceof Endpoint) {
                endpoints.put(key, o);
                continue;
            }
            if (o instanceof Entry) {
                entries.put(key, o);
                continue;
            }
            SynapseXMLConfigurationSerializer.handleException("Unknown object : " + o.getClass() + " for serialization into Synapse configuration");
        }
        SynapseXMLConfigurationSerializer.serializeEntries(definitions, entries);
        SynapseXMLConfigurationSerializer.serializeEndpoints(definitions, endpoints);
        SynapseXMLConfigurationSerializer.serializeSequences(definitions, sequences);
        SynapseXMLConfigurationSerializer.serializeStartups(definitions, synCfg.getStartups());
        return definitions;
    }

    private static void serializeEntries(OMElement definitions, Map entries) {
        for (String key : entries.keySet()) {
            EntrySerializer.serializeEntry((Entry)entries.get(key), definitions);
        }
    }

    private static void serializeStartups(OMElement definitions, Collection startups) {
        for (Startup s : startups) {
            StartupFinder.getInstance().serializeStartup(definitions, s);
        }
    }

    private static void serializeEndpoints(OMElement definitions, Map endpoints) {
        for (String key : endpoints.keySet()) {
            Object o = endpoints.get(key);
            if (!(o instanceof Endpoint)) continue;
            Endpoint endpoint = (Endpoint)o;
            OMElement epElement = EndpointAbstractSerializer.getEndpointSerializer(endpoint).serializeEndpoint(endpoint);
            definitions.addChild((OMNode)epElement);
        }
    }

    private static void serializeSequences(OMElement definitions, Map sequences) {
        for (String key : sequences.keySet()) {
            Mediator mediator = (Mediator)sequences.get(key);
            MediatorSerializerFinder.getInstance().getSerializer(mediator).serializeMediator(definitions, mediator);
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public QName getTagQName() {
        return XMLConfigConstants.DEFINITIONS_ELT;
    }
}

