/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.Startup;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.ConfigurationFactory;
import org.apache.synapse.config.xml.EntryFactory;
import org.apache.synapse.config.xml.MediatorFactoryFinder;
import org.apache.synapse.config.xml.ProxyServiceFactory;
import org.apache.synapse.config.xml.RegistryFactory;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.config.xml.SynapseXMLConfigurationSerializer;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.XMLConfigurationBuilder;
import org.apache.synapse.config.xml.endpoints.EndpointAbstractFactory;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.DropMediator;
import org.apache.synapse.mediators.builtin.LogMediator;
import org.jaxen.JaxenException;

public class SynapseXMLConfigurationFactory
implements ConfigurationFactory {
    private static Log log = LogFactory.getLog(SynapseXMLConfigurationFactory.class);

    public SynapseConfiguration getConfiguration(OMElement definitions) {
        if (!definitions.getQName().equals(XMLConfigConstants.DEFINITIONS_ELT)) {
            throw new SynapseException("Wrong QName for this config factory " + definitions.getQName());
        }
        SynapseConfiguration config = new SynapseConfiguration();
        config.setDefaultQName(definitions.getQName());
        SequenceMediator rootSequence = new SequenceMediator();
        rootSequence.setName("main");
        Iterator iter = definitions.getChildren();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof OMElement)) continue;
            OMElement elt = (OMElement)o;
            if (XMLConfigConstants.SEQUENCE_ELT.equals(elt.getQName())) {
                String key = elt.getAttributeValue(new QName("", "key"));
                if (key != null) {
                    Mediator m = MediatorFactoryFinder.getInstance().getMediator(elt);
                    rootSequence.addChild(m);
                    continue;
                }
                SynapseXMLConfigurationFactory.defineSequence(config, elt);
                continue;
            }
            if (XMLConfigConstants.ENDPOINT_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineEndpoint(config, elt);
                continue;
            }
            if (XMLConfigConstants.ENTRY_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineEntry(config, elt);
                continue;
            }
            if (XMLConfigConstants.PROXY_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineProxy(config, elt);
                continue;
            }
            if (XMLConfigConstants.REGISTRY_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineRegistry(config, elt);
                continue;
            }
            if (XMLConfigConstants.TASK_ELT.equals(elt.getQName())) {
                SynapseXMLConfigurationFactory.defineStartup(config, elt);
                continue;
            }
            Mediator m = MediatorFactoryFinder.getInstance().getMediator(elt);
            rootSequence.addChild(m);
        }
        if (config.getLocalRegistry().isEmpty() && config.getProxyServices().isEmpty() && rootSequence.getList().isEmpty() && config.getRegistry() != null) {
            OMNode remoteConfigNode = config.getRegistry().lookup("synapse.xml");
            try {
                config = XMLConfigurationBuilder.getConfiguration(SynapseConfigUtils.getStreamSource(remoteConfigNode).getInputStream());
            }
            catch (XMLStreamException xse) {
                throw new SynapseException("Problem loading remote synapse.xml ", xse);
            }
        }
        if (!config.getLocalRegistry().containsKey("main")) {
            if (rootSequence.getList().isEmpty() && config.getMainSequence() == null) {
                SynapseXMLConfigurationFactory.setDefaultMainSequence(config);
            } else {
                config.addSequence(rootSequence.getName(), rootSequence);
            }
        } else if (!rootSequence.getList().isEmpty()) {
            SynapseXMLConfigurationFactory.handleException("Invalid Synapse Configuration : Conflict in resolving the \"main\" mediator\n\tSynapse Configuration cannot have sequence named \"main\" and toplevel mediators simultaniously");
        }
        if (config.getFaultSequence() == null) {
            SynapseXMLConfigurationFactory.setDefaultFaultSequence(config);
        }
        return config;
    }

    private static void defineRegistry(SynapseConfiguration config, OMElement elem) {
        if (config.getRegistry() != null) {
            SynapseXMLConfigurationFactory.handleException("Only one remote registry can be defined within a configuration");
        }
        config.setRegistry(RegistryFactory.createRegistry(elem));
    }

    private static void defineStartup(SynapseConfiguration config, OMElement elem) {
        Startup startup = StartupFinder.getInstance().getStartup(elem);
        if (config.getStartup(startup.getName()) != null) {
            SynapseXMLConfigurationFactory.handleException("Duplicate startup with name : " + startup.getName());
        }
        config.addStartup(startup);
    }

    private static void defineProxy(SynapseConfiguration config, OMElement elem) {
        ProxyService proxy = ProxyServiceFactory.createProxy(elem);
        if (config.getProxyService(proxy.getName()) != null) {
            SynapseXMLConfigurationFactory.handleException("Duplicate proxy service with name : " + proxy.getName());
        }
        config.addProxyService(proxy.getName(), proxy);
    }

    private static void defineEntry(SynapseConfiguration config, OMElement elem) {
        Entry entry = EntryFactory.createEntry(elem);
        if (config.getLocalRegistry().get(entry.getKey()) != null) {
            SynapseXMLConfigurationFactory.handleException("Duplicate registry entry definition for key : " + entry.getKey());
        }
        config.addEntry(entry.getKey(), entry);
    }

    public static void defineSequence(SynapseConfiguration config, OMElement ele) {
        String name = ele.getAttributeValue(new QName("", "name"));
        if (name != null) {
            if (config.getLocalRegistry().get(name) != null) {
                SynapseXMLConfigurationFactory.handleException("Duplicate sequence definition : " + name);
            }
            config.addSequence(name, MediatorFactoryFinder.getInstance().getMediator(ele));
        } else {
            SynapseXMLConfigurationFactory.handleException("Invalid sequence definition without a name");
        }
    }

    public static void defineEndpoint(SynapseConfiguration config, OMElement ele) {
        String name = ele.getAttributeValue(new QName("", "name"));
        if (name != null) {
            if (config.getLocalRegistry().get(name.trim()) != null) {
                SynapseXMLConfigurationFactory.handleException("Duplicate endpoint definition : " + name);
            }
            Endpoint endpoint = EndpointAbstractFactory.getEndpointFactroy(ele).createEndpoint(ele, false);
            config.addEndpoint(name.trim(), endpoint);
        } else {
            SynapseXMLConfigurationFactory.handleException("Invalid endpoint definition without a name");
        }
    }

    private static void setDefaultMainSequence(SynapseConfiguration config) {
        SequenceMediator main = new SequenceMediator();
        main.setName("main");
        main.addChild(new LogMediator());
        main.addChild(new DropMediator());
        config.addSequence("main", main);
    }

    private static void setDefaultFaultSequence(SynapseConfiguration config) {
        SequenceMediator fault = new SequenceMediator();
        fault.setName("fault");
        LogMediator log = new LogMediator();
        log.setLogLevel(3);
        MediatorProperty mp = new MediatorProperty();
        mp.setName("MESSAGE");
        mp.setValue("Executing default \"fault\" sequence");
        log.addProperty(mp);
        mp = new MediatorProperty();
        mp.setName("ERROR_CODE");
        try {
            mp.setExpression(new AXIOMXPath("get-property('ERROR_CODE')"));
        }
        catch (JaxenException ignore) {
            // empty catch block
        }
        log.addProperty(mp);
        mp = new MediatorProperty();
        mp.setName("ERROR_MESSAGE");
        try {
            mp.setExpression(new AXIOMXPath("get-property('ERROR_MESSAGE')"));
        }
        catch (JaxenException ignore) {
            // empty catch block
        }
        log.addProperty(mp);
        fault.addChild(log);
        fault.addChild(new DropMediator());
        config.addSequence("fault", fault);
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    private static void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, e);
    }

    public QName getTagQName() {
        return XMLConfigConstants.DEFINITIONS_ELT;
    }

    public Class getSerializerClass() {
        return SynapseXMLConfigurationSerializer.class;
    }
}

