/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.MediatorPropertyFactory;
import org.apache.synapse.mediators.builtin.LogMediator;

public class LogMediatorFactory
extends AbstractMediatorFactory {
    private static final QName LOG_Q = new QName("http://ws.apache.org/ns/synapse", "log");
    private static final String SIMPLE = "simple";
    private static final String HEADERS = "headers";
    private static final String FULL = "full";
    private static final String CUSTOM = "custom";
    private static final QName ATT_LEVEL = new QName("level");
    private static final QName ATT_SEPERATOR = new QName("separator");

    public QName getTagQName() {
        return LOG_Q;
    }

    public Mediator createMediator(OMElement elem) {
        OMAttribute separator;
        LogMediator logMediator = new LogMediator();
        this.processTraceState(logMediator, elem);
        OMAttribute level = elem.getAttribute(ATT_LEVEL);
        if (level != null) {
            String levelstr = level.getAttributeValue();
            if (SIMPLE.equals(levelstr)) {
                logMediator.setLogLevel(1);
            } else if (HEADERS.equals(levelstr)) {
                logMediator.setLogLevel(2);
            } else if (FULL.equals(levelstr)) {
                logMediator.setLogLevel(3);
            } else if (CUSTOM.equals(levelstr)) {
                logMediator.setLogLevel(0);
            }
        }
        if ((separator = elem.getAttribute(ATT_SEPERATOR)) != null) {
            logMediator.setSeparator(separator.getAttributeValue());
        }
        logMediator.addAllProperties(MediatorPropertyFactory.getMediatorProperties(elem));
        return logMediator;
    }
}

