/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractListMediatorFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.mediators.filters.FilterMediator;
import org.jaxen.JaxenException;

public class FilterMediatorFactory
extends AbstractListMediatorFactory {
    private static final QName FILTER_Q = new QName("http://ws.apache.org/ns/synapse", "filter");

    public Mediator createMediator(OMElement elem) {
        FilterMediator filter = new FilterMediator();
        OMAttribute attXpath = elem.getAttribute(ATT_XPATH);
        OMAttribute attSource = elem.getAttribute(ATT_SOURCE);
        OMAttribute attRegex = elem.getAttribute(ATT_REGEX);
        if (attXpath != null) {
            if (attXpath.getAttributeValue() != null && attXpath.getAttributeValue().trim().length() == 0) {
                String msg = "Invalid attribute value specified for xpath";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            try {
                filter.setXpath(new AXIOMXPath(attXpath.getAttributeValue()));
            }
            catch (JaxenException e) {
                String msg = "Invalid XPath expression for attribute xpath : " + attXpath.getAttributeValue();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            OMElementUtils.addNameSpaces(filter.getXpath(), elem, log);
        } else if (attSource != null && attRegex != null) {
            if (attSource.getAttributeValue() != null && attSource.getAttributeValue().trim().length() == 0 || attRegex.getAttributeValue() != null && attRegex.getAttributeValue().trim().length() == 0) {
                String msg = "Invalid attribute values for source and/or regex specified";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            try {
                filter.setSource(new AXIOMXPath(attSource.getAttributeValue()));
            }
            catch (JaxenException e) {
                String msg = "Invalid XPath expression for attribute source : " + attSource.getAttributeValue();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            try {
                filter.setRegex(Pattern.compile(attRegex.getAttributeValue()));
            }
            catch (PatternSyntaxException pse) {
                String msg = "Invalid Regular Expression for attribute regex : " + attRegex.getAttributeValue();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            OMElementUtils.addNameSpaces(filter.getSource(), elem, log);
        } else {
            String msg = "An xpath or (source, regex) attributes are required for a filter";
            log.error((Object)msg);
            throw new SynapseException(msg);
        }
        this.processTraceState(filter, elem);
        FilterMediatorFactory.addChildren(elem, filter);
        return filter;
    }

    public QName getTagQName() {
        return FILTER_Q;
    }
}

