/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.OMElementUtils;
import org.apache.synapse.mediators.transform.FaultMediator;
import org.jaxen.JaxenException;

public class FaultMediatorFactory
extends AbstractMediatorFactory {
    private static final QName FAULT_Q = new QName("http://ws.apache.org/ns/synapse", "makefault");
    private static final QName ATT_VERSION_Q = new QName("", "version");
    private static final QName CODE_Q = new QName("http://ws.apache.org/ns/synapse", "code");
    private static final QName REASON_Q = new QName("http://ws.apache.org/ns/synapse", "reason");
    private static final QName NODE_Q = new QName("http://ws.apache.org/ns/synapse", "node");
    private static final QName ROLE_Q = new QName("http://ws.apache.org/ns/synapse", "role");
    private static final QName DETAIL_Q = new QName("http://ws.apache.org/ns/synapse", "detail");
    private static final String SOAP11 = "soap11";
    private static final String SOAP12 = "soap12";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Mediator createMediator(OMElement elem) {
        OMElement detail;
        OMElement role;
        String msg;
        String msg2;
        OMElement code;
        FaultMediator faultMediator = new FaultMediator();
        OMAttribute version = elem.getAttribute(ATT_VERSION_Q);
        if (version != null) {
            if (SOAP11.equals(version.getAttributeValue())) {
                faultMediator.setSoapVersion(1);
            } else {
                if (!SOAP12.equals(version.getAttributeValue())) {
                    String msg3 = "Invalid SOAP version";
                    log.error((Object)msg3);
                    throw new SynapseException(msg3);
                }
                faultMediator.setSoapVersion(2);
            }
        }
        if ((code = elem.getFirstChildWithName(CODE_Q)) == null) {
            String msg4 = "The fault code is a required attribute for the makefault mediator";
            log.error((Object)msg4);
            throw new SynapseException(msg4);
        }
        OMAttribute value = code.getAttribute(ATT_VALUE);
        OMAttribute expression = code.getAttribute(ATT_EXPRN);
        if (value != null) {
            String strValue = value.getAttributeValue();
            if (strValue.indexOf(":") == -1) {
                String msg5 = "A QName is expected for fault code as prefix:name";
                log.error((Object)msg5);
                throw new SynapseException(msg5);
            }
            String prefix = strValue.substring(0, strValue.indexOf(":"));
            String name = strValue.substring(strValue.indexOf(":") + 1);
            String namespaceURI = OMElementUtils.getNameSpaceWithPrefix(prefix, code);
            if (namespaceURI == null) {
                String msg6 = "Invalid namespace prefix '" + prefix + "' in code attribute";
                log.error((Object)msg6);
                throw new SynapseException(msg6);
            }
            faultMediator.setFaultCodeValue(new QName(namespaceURI, name, prefix));
        } else {
            if (expression == null) {
                String msg7 = "A 'value' or 'expression' attribute must specify the fault code";
                log.error((Object)msg7);
                throw new SynapseException(msg7);
            }
            try {
                AXIOMXPath xp = new AXIOMXPath(expression.getAttributeValue());
                OMElementUtils.addNameSpaces(xp, code, log);
                faultMediator.setFaultCodeExpr(xp);
            }
            catch (JaxenException je) {
                String msg8 = "Invalid fault code expression : " + je.getMessage();
                log.error((Object)msg8);
                throw new SynapseException(msg8, je);
            }
        }
        OMElement reason = elem.getFirstChildWithName(REASON_Q);
        if (reason == null) {
            String msg9 = "The fault reason is a required attribute for the makefault mediator";
            log.error((Object)msg9);
            throw new SynapseException(msg9);
        }
        OMAttribute value2 = reason.getAttribute(ATT_VALUE);
        OMAttribute expression2 = reason.getAttribute(ATT_EXPRN);
        if (value2 != null) {
            faultMediator.setFaultReasonValue(value2.getAttributeValue());
        } else {
            if (expression2 == null) {
                msg2 = "A 'value' or 'expression' attribute must specify the fault code";
                log.error((Object)msg2);
                throw new SynapseException(msg2);
            }
            try {
                AXIOMXPath xp = new AXIOMXPath(expression2.getAttributeValue());
                OMElementUtils.addNameSpaces(xp, reason, log);
                faultMediator.setFaultReasonExpr(xp);
            }
            catch (JaxenException je) {
                msg = "Invalid fault reason expression : " + je.getMessage();
                log.error((Object)msg);
                throw new SynapseException(msg, je);
            }
        }
        this.processTraceState(faultMediator, elem);
        OMElement node = elem.getFirstChildWithName(NODE_Q);
        if (node != null && node.getText() != null) {
            try {
                faultMediator.setFaultNode(new URI(node.getText()));
            }
            catch (URISyntaxException e) {
                msg2 = "Invalid URI specified for fault node : " + node.getText();
                log.error((Object)msg2);
                throw new SynapseException(msg2);
            }
        }
        if ((role = elem.getFirstChildWithName(ROLE_Q)) != null && role.getText() != null) {
            try {
                faultMediator.setFaultRole(new URI(role.getText()));
            }
            catch (URISyntaxException e) {
                msg = "Invalid URI specified for fault role : " + role.getText();
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
        }
        if ((detail = elem.getFirstChildWithName(DETAIL_Q)) != null && detail.getText() != null) {
            faultMediator.setFaultDetail(detail.getText());
        }
        return faultMediator;
    }

    public QName getTagQName() {
        return FAULT_Q;
    }
}

